/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.MemoryEvent;
import org.apache.geode.internal.cache.control.MemoryThresholds;
import org.apache.geode.internal.cache.control.ResourceEvent;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ResourceAdvisor
extends DistributionAdvisor {
    private static final Logger logger = LogService.getLogger();

    private ResourceAdvisor(DistributionAdvisee advisee) {
        super(advisee);
    }

    public static ResourceAdvisor createResourceAdvisor(DistributionAdvisee advisee) {
        ResourceAdvisor advisor = new ResourceAdvisor(advisee);
        advisor.initialize();
        return advisor;
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new ResourceManagerProfile(memberId, version);
    }

    private InternalResourceManager getResourceManager() {
        return ((InternalCache)((Object)this.getAdvisee())).getInternalResourceManager(false);
    }

    @Override
    protected boolean evaluateProfiles(DistributionAdvisor.Profile newProfile, DistributionAdvisor.Profile oldProfile) {
        ResourceManagerProfile oldRMProfile = (ResourceManagerProfile)oldProfile;
        ResourceManagerProfile newRMProfile = (ResourceManagerProfile)newProfile;
        ArrayList<MemoryEvent> eventsToDeliver = new ArrayList<MemoryEvent>();
        if (oldRMProfile == null) {
            eventsToDeliver.add(new MemoryEvent(InternalResourceManager.ResourceType.HEAP_MEMORY, MemoryThresholds.MemoryState.DISABLED, newRMProfile.heapState, newRMProfile.getDistributedMember(), newRMProfile.heapBytesUsed, false, newRMProfile.heapThresholds));
            eventsToDeliver.add(new MemoryEvent(InternalResourceManager.ResourceType.OFFHEAP_MEMORY, MemoryThresholds.MemoryState.DISABLED, newRMProfile.offHeapState, newRMProfile.getDistributedMember(), newRMProfile.offHeapBytesUsed, false, newRMProfile.offHeapThresholds));
        } else {
            if (oldRMProfile.heapState != newRMProfile.heapState) {
                eventsToDeliver.add(new MemoryEvent(InternalResourceManager.ResourceType.HEAP_MEMORY, oldRMProfile.heapState, newRMProfile.heapState, newRMProfile.getDistributedMember(), newRMProfile.heapBytesUsed, false, newRMProfile.heapThresholds));
            }
            if (newRMProfile.heapState == MemoryThresholds.MemoryState.DISABLED) {
                newRMProfile.setHeapData(oldRMProfile.heapBytesUsed, oldRMProfile.heapState, oldRMProfile.heapThresholds);
            }
            if (oldRMProfile.offHeapState != newRMProfile.offHeapState) {
                eventsToDeliver.add(new MemoryEvent(InternalResourceManager.ResourceType.OFFHEAP_MEMORY, oldRMProfile.offHeapState, newRMProfile.offHeapState, newRMProfile.getDistributedMember(), newRMProfile.offHeapBytesUsed, false, newRMProfile.offHeapThresholds));
            }
            if (newRMProfile.offHeapState == MemoryThresholds.MemoryState.DISABLED) {
                newRMProfile.setOffHeapData(oldRMProfile.offHeapBytesUsed, oldRMProfile.offHeapState, oldRMProfile.offHeapThresholds);
            }
        }
        for (ResourceEvent resourceEvent : eventsToDeliver) {
            this.getResourceManager().deliverEventFromRemote(resourceEvent);
        }
        return true;
    }

    public String toString() {
        return "ResourceAdvisor for ResourceManager " + this.getAdvisee();
    }

    public Set<InternalDistributedMember> adviseCriticalMembers() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                ResourceManagerProfile rmp = (ResourceManagerProfile)profile;
                return rmp.getHeapState().isCritical();
            }
        });
    }

    public boolean isHeapCritical(InternalDistributedMember member) {
        ResourceManagerProfile rmp = (ResourceManagerProfile)this.getProfile(member);
        return rmp != null ? rmp.getHeapState().isCritical() : false;
    }

    public synchronized void updateRemoteProfile() {
        Set<InternalDistributedMember> recips = this.adviseGeneric();
        ResourceManagerProfile profile = new ResourceManagerProfile(this.getDistributionManager().getId(), this.incrementAndGetVersion());
        this.getResourceManager().fillInProfile(profile);
        ResourceProfileMessage.send(this.getResourceManager(), recips, profile);
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        ResourceManagerProfile oldp = (ResourceManagerProfile)profile;
        this.getResourceManager().deliverEventFromRemote(oldp.createDisabledMemoryEvent(InternalResourceManager.ResourceType.HEAP_MEMORY));
        this.getResourceManager().deliverEventFromRemote(oldp.createDisabledMemoryEvent(InternalResourceManager.ResourceType.OFFHEAP_MEMORY));
    }

    @Override
    public void close() {
        new UpdateAttributesProcessor(this.getAdvisee(), true).distribute(false);
        super.close();
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    public static class ResourceManagerProfile
    extends DistributionAdvisor.Profile {
        private long heapBytesUsed;
        private MemoryThresholds.MemoryState heapState;
        private MemoryThresholds heapThresholds;
        private long offHeapBytesUsed;
        private MemoryThresholds.MemoryState offHeapState;
        private MemoryThresholds offHeapThresholds;

        public ResourceManagerProfile() {
        }

        public ResourceManagerProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public synchronized ResourceManagerProfile setHeapData(long heapBytesUsed, MemoryThresholds.MemoryState heapState, MemoryThresholds heapThresholds) {
            this.heapBytesUsed = heapBytesUsed;
            this.heapState = heapState;
            this.heapThresholds = heapThresholds;
            return this;
        }

        public synchronized ResourceManagerProfile setOffHeapData(long offHeapBytesUsed, MemoryThresholds.MemoryState offHeapState, MemoryThresholds offHeapThresholds) {
            this.offHeapBytesUsed = offHeapBytesUsed;
            this.offHeapState = offHeapState;
            this.offHeapThresholds = offHeapThresholds;
            return this;
        }

        public synchronized MemoryEvent createDisabledMemoryEvent(InternalResourceManager.ResourceType resourceType) {
            if (resourceType == InternalResourceManager.ResourceType.HEAP_MEMORY) {
                return new MemoryEvent(InternalResourceManager.ResourceType.HEAP_MEMORY, this.heapState, MemoryThresholds.MemoryState.DISABLED, this.getDistributedMember(), this.heapBytesUsed, false, this.heapThresholds);
            }
            return new MemoryEvent(InternalResourceManager.ResourceType.OFFHEAP_MEMORY, this.offHeapState, MemoryThresholds.MemoryState.DISABLED, this.getDistributedMember(), this.offHeapBytesUsed, false, this.offHeapThresholds);
        }

        @Override
        public void processIncoming(ClusterDistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            InternalCache cache = dm.getCache();
            if (cache != null && !cache.isClosed()) {
                this.handleDistributionAdvisee((DistributionAdvisee)((Object)cache), removeProfile, exchangeProfiles, replyProfiles);
            }
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("ResourceAdvisor.ResourceManagerProfile");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            ResourceManagerProfile resourceManagerProfile = this;
            synchronized (resourceManagerProfile) {
                sb.append("; heapState=").append((Object)this.heapState).append("; heapBytesUsed=").append(this.heapBytesUsed).append("; heapThresholds=").append(this.heapThresholds).append("; offHeapState=").append((Object)this.offHeapState).append("; offHeapBytesUsed=").append(this.offHeapBytesUsed).append("; offHeapThresholds=").append(this.offHeapThresholds);
            }
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            long heapBytesUsed = in.readLong();
            MemoryThresholds.MemoryState heapState = MemoryThresholds.MemoryState.fromData(in);
            MemoryThresholds heapThresholds = MemoryThresholds.fromData(in);
            this.setHeapData(heapBytesUsed, heapState, heapThresholds);
            long offHeapBytesUsed = in.readLong();
            MemoryThresholds.MemoryState offHeapState = MemoryThresholds.MemoryState.fromData(in);
            MemoryThresholds offHeapThresholds = MemoryThresholds.fromData(in);
            this.setOffHeapData(offHeapBytesUsed, offHeapState, offHeapThresholds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            MemoryThresholds offHeapThresholds;
            MemoryThresholds.MemoryState offHeapState;
            long offHeapBytesUsed;
            MemoryThresholds heapThresholds;
            MemoryThresholds.MemoryState heapState;
            long heapBytesUsed;
            ResourceManagerProfile resourceManagerProfile = this;
            synchronized (resourceManagerProfile) {
                heapBytesUsed = this.heapBytesUsed;
                heapState = this.heapState;
                heapThresholds = this.heapThresholds;
                offHeapBytesUsed = this.offHeapBytesUsed;
                offHeapState = this.offHeapState;
                offHeapThresholds = this.offHeapThresholds;
            }
            super.toData(out, context);
            out.writeLong(heapBytesUsed);
            heapState.toData(out);
            heapThresholds.toData(out);
            out.writeLong(offHeapBytesUsed);
            offHeapState.toData(out);
            offHeapThresholds.toData(out);
        }

        @Override
        public int getDSFID() {
            return -107;
        }

        public synchronized MemoryThresholds.MemoryState getHeapState() {
            return this.heapState;
        }

        public synchronized MemoryThresholds.MemoryState getoffHeapState() {
            return this.offHeapState;
        }
    }

    public static class ResourceProfileMessage
    extends HighPriorityDistributionMessage {
        private volatile ResourceManagerProfile[] profiles;
        private volatile int processorId;

        public ResourceProfileMessage() {
        }

        private ResourceProfileMessage(Set<InternalDistributedMember> recips, ResourceManagerProfile profile) {
            this.setRecipients(recips);
            this.processorId = 0;
            this.profiles = new ResourceManagerProfile[]{profile};
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void process(ClusterDistributionManager dm) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public int getDSFID() {
            return -108;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.processorId = in.readInt();
            int l = in.readInt();
            if (l != -1) {
                this.profiles = new ResourceManagerProfile[l];
                for (int i = 0; i < this.profiles.length; ++i) {
                    ResourceManagerProfile r = new ResourceManagerProfile();
                    InternalDataSerializer.invokeFromData(r, in);
                    this.profiles[i] = r;
                }
            } else {
                this.profiles = null;
            }
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.processorId);
            if (this.profiles != null) {
                out.writeInt(this.profiles.length);
                for (int i = 0; i < this.profiles.length; ++i) {
                    InternalDataSerializer.invokeToData(this.profiles[i], out);
                }
            } else {
                out.writeInt(-1);
            }
        }

        public static void send(InternalResourceManager irm, Set<InternalDistributedMember> recips, ResourceManagerProfile profile) {
            DistributionManager dm = irm.getResourceAdvisor().getDistributionManager();
            ResourceProfileMessage r = new ResourceProfileMessage(recips, profile);
            dm.putOutgoing(r);
        }

        @Override
        public String getShortClassName() {
            return "ResourceProfileMessage";
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getShortClassName()).append(" (processorId=").append(this.processorId).append("; profiles=[");
            for (int i = 0; i < this.profiles.length; ++i) {
                sb.append(this.profiles[i]);
                if (i >= this.profiles.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            sb.append(")");
            return sb.toString();
        }
    }
}

