/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntry;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryHeap;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryOffHeapUUIDKey;
import org.apache.geode.internal.cache.entries.VersionedThinDiskRegionEntryOffHeap;

public abstract class VMThinDiskRegionEntryOffHeap
extends VMThinDiskRegionEntry
implements OffHeapRegionEntry {
    @Immutable
    private static final VMThinDiskRegionEntryOffHeapFactory factory = new VMThinDiskRegionEntryOffHeapFactory();

    public VMThinDiskRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinDiskRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMThinDiskRegionEntryOffHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinDiskRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinDiskRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinDiskRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinDiskRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinDiskRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinDiskRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VMThinDiskRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinDiskRegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMThinDiskRegionEntryHeap.getEntryFactory();
        }
    }
}

