/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.internal.statistics.ResourceInstance;
import org.apache.geode.internal.statistics.SampleCollector;
import org.apache.geode.internal.statistics.StatMonitorHandler;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticsListener;
import org.apache.geode.internal.statistics.StatisticsNotification;

public abstract class StatisticsMonitor {
    private final Object mutex = new Object();
    private final Set<StatisticsListener> listeners = ConcurrentHashMap.newKeySet();
    private final Set<StatisticId> statisticIds = ConcurrentHashMap.newKeySet();

    public StatisticsMonitor addStatistic(StatisticId statId) {
        if (statId == null) {
            throw new NullPointerException("StatisticId is null");
        }
        if (!this.statisticIds.contains(statId)) {
            this.statisticIds.add(statId);
        }
        return this;
    }

    public StatisticsMonitor removeStatistic(StatisticId statId) {
        if (statId == null) {
            throw new NullPointerException("StatisticId is null");
        }
        if (this.statisticIds.contains(statId)) {
            this.statisticIds.remove(statId);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(StatisticsListener listener) {
        if (listener == null) {
            throw new NullPointerException("StatisticsListener is null");
        }
        Object object = this.mutex;
        synchronized (object) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
                this.getStatMonitorHandler().addMonitor(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(StatisticsListener listener) {
        if (listener == null) {
            throw new NullPointerException("StatisticsListener is null");
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.listeners.contains(listener)) {
                this.listeners.remove(listener);
                if (this.listeners.isEmpty()) {
                    try {
                        this.getStatMonitorHandler().removeMonitor(this);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void monitor(long millisTimeStamp, List<ResourceInstance> resourceInstances) {
        this.monitorStatisticIds(millisTimeStamp, resourceInstances);
    }

    private void monitorStatisticIds(long millisTimeStamp, List<ResourceInstance> resourceInstances) {
        if (!this.statisticIds.isEmpty()) {
            // empty if block
        }
    }

    protected void notifyListeners(StatisticsNotification notification) {
        for (StatisticsListener listener : this.listeners) {
            listener.handleNotification(notification);
        }
    }

    protected Object mutex() {
        return this.mutex;
    }

    StatMonitorHandler getStatMonitorHandler() {
        return SampleCollector.getStatMonitorHandler();
    }

    Set<StatisticsListener> getStatisticsListenersSnapshot() {
        return this.listeners;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("statisticIds=").append(this.statisticIds);
        sb.append(", listeners=").append(this.listeners);
        StringBuilder toAppend = this.appendToString();
        if (toAppend == null) {
            sb.append(", ").append((CharSequence)toAppend);
        }
        sb.append("}");
        return sb.toString();
    }

    protected StringBuilder appendToString() {
        return null;
    }
}

