/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.apache.geode.StatisticsType;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.StatisticsTypeImpl;

public class StripedStatisticsImpl
extends StatisticsImpl {
    private final LongAdder[] longAdders;
    private final DoubleAdder[] doubleAdders;
    private final int longCount;

    public StripedStatisticsImpl(StatisticsType type, String textId, long numericId, long uniqueId, StatisticsManager statisticsManager) {
        super(type, textId, numericId, uniqueId, 0, statisticsManager);
        StatisticsTypeImpl realType = (StatisticsTypeImpl)type;
        this.longCount = realType.getLongStatCount();
        this.longAdders = (LongAdder[])Stream.generate(LongAdder::new).limit(realType.getLongStatCount()).toArray(LongAdder[]::new);
        this.doubleAdders = (DoubleAdder[])Stream.generate(DoubleAdder::new).limit(realType.getDoubleStatCount()).toArray(DoubleAdder[]::new);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    private int getOffsetFromLongId(int id) {
        return id;
    }

    private int getOffsetFromDoubleId(int id) {
        return id - this.longCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setLong(int id, long value) {
        int offset = this.getOffsetFromLongId(id);
        LongAdder longAdder = this.longAdders[offset];
        synchronized (longAdder) {
            this.longAdders[offset].reset();
            this.longAdders[offset].add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setDouble(int id, double value) {
        int offset = this.getOffsetFromDoubleId(id);
        DoubleAdder doubleAdder = this.doubleAdders[offset];
        synchronized (doubleAdder) {
            this.doubleAdders[offset].reset();
            this.doubleAdders[offset].add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long _getLong(int id) {
        int offset = this.getOffsetFromLongId(id);
        LongAdder longAdder = this.longAdders[offset];
        synchronized (longAdder) {
            return this.longAdders[offset].sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected double _getDouble(int id) {
        int offset = this.getOffsetFromDoubleId(id);
        DoubleAdder doubleAdder = this.doubleAdders[offset];
        synchronized (doubleAdder) {
            return this.doubleAdders[offset].sum();
        }
    }

    @Override
    protected void _incLong(int id, long delta) {
        int offset = this.getOffsetFromLongId(id);
        this.longAdders[offset].add(delta);
    }

    @Override
    protected void _incDouble(int id, double delta) {
        int offset = this.getOffsetFromDoubleId(id);
        this.doubleAdders[offset].add(delta);
    }
}

