/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.util.TimeScheduler;

public class TimeService
implements Runnable {
    protected TimeScheduler timer;
    protected volatile Future<?> task;
    protected long interval = 500L;
    protected volatile long timestamp;

    public TimeService(TimeScheduler timer) {
        this(timer, 500L);
    }

    public TimeService(TimeScheduler timer, long interval) {
        this.timer = timer;
        this.interval = interval;
    }

    public long timestamp() {
        return this.timestamp > 0L ? this.timestamp : (this.timestamp = System.nanoTime());
    }

    public long interval() {
        return this.interval;
    }

    public TimeService interval(long interval) {
        if (interval != this.interval) {
            this.interval = interval;
        }
        return this;
    }

    public boolean running() {
        return this.task != null && !this.task.isDone();
    }

    public TimeService start() {
        this.startTask();
        return this;
    }

    public TimeService stop() {
        this.stopTask();
        return this;
    }

    @Override
    public void run() {
        this.timestamp = System.nanoTime();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (interval=" + this.interval + "ms)";
    }

    protected synchronized void startTask() {
        this.stopTask();
        this.task = this.timer != null ? this.timer.scheduleWithFixedDelay(this, this.interval, this.interval, TimeUnit.MILLISECONDS) : null;
    }

    protected synchronized void stopTask() {
        if (this.task != null) {
            this.task.cancel(false);
            this.task = null;
        }
    }
}

