/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import org.multiverse.api.Txn;
import org.multiverse.api.exceptions.TxnMandatoryException;

public final class TxnThreadLocal {
    public static final ThreadLocal<Container> threadlocal = new ThreadLocal<Container>(){

        @Override
        protected Container initialValue() {
            return new Container();
        }
    };

    public static Txn getThreadLocalTxn() {
        return TxnThreadLocal.threadlocal.get().txn;
    }

    public static Container getThreadLocalTxnContainer() {
        return threadlocal.get();
    }

    public static Txn getRequiredThreadLocalTxn() {
        Txn txn = TxnThreadLocal.threadlocal.get().txn;
        if (txn == null) {
            throw new TxnMandatoryException("No transaction is found on the TxnThreadLocal");
        }
        return txn;
    }

    public static void clearThreadLocalTxn() {
        TxnThreadLocal.threadlocal.get().txn = null;
    }

    public static void setThreadLocalTxn(Txn txn) {
        TxnThreadLocal.threadlocal.get().txn = txn;
    }

    private TxnThreadLocal() {
    }

    public static class Container {
        public Txn txn;
        public Object txPool;
    }
}

