/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.dataproviders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.CustomizedStateCache;
import org.apache.helix.common.caches.CustomizedViewCache;
import org.apache.helix.common.caches.PropertyCache;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.common.CapacityNode;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.pipeline.Pipeline;
import org.apache.helix.controller.rebalancer.strategy.GreedyRebalanceStrategy;
import org.apache.helix.controller.rebalancer.waged.WagedInstanceCapacity;
import org.apache.helix.controller.rebalancer.waged.WagedResourceWeightsProvider;
import org.apache.helix.controller.stages.MissingTopStateRecord;
import org.apache.helix.model.CustomizedState;
import org.apache.helix.model.CustomizedStateConfig;
import org.apache.helix.model.CustomizedView;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceControllerDataProvider
extends BaseControllerDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(ResourceControllerDataProvider.class);
    private static final String PIPELINE_NAME = Pipeline.Type.DEFAULT.name();
    private final PropertyCache<ExternalView> _externalViewCache;
    private final PropertyCache<ExternalView> _targetExternalViewCache;
    private final CustomizedStateCache _customizedStateCache;
    private final Map<String, CustomizedViewCache> _customizedViewCacheMap;
    private Map<String, ResourceAssignment> _resourceAssignmentCache;
    private Map<String, ZNRecord> _idealMappingCache;
    private Map<String, Map<String, MissingTopStateRecord>> _missingTopStateMap;
    private Map<String, Map<String, String>> _lastTopStateLocationMap;
    private Set<HelixConstants.ChangeType> _refreshedChangeTypes;
    private Set<String> _aggregationEnabledTypes = new HashSet<String>();
    private Set<CapacityNode> _simpleCapacitySet;
    private final Set<String> _disabledInstancesForAllPartitionsSet = new HashSet<String>();
    private final Map<String, List<String>> _stablePartitionListCache = new HashMap<String, List<String>>();
    WagedInstanceCapacity _wagedInstanceCapacity;
    WagedResourceWeightsProvider _wagedPartitionWeightProvider;

    public ResourceControllerDataProvider() {
        this("UNKNOWN_CLUSTER");
    }

    public ResourceControllerDataProvider(String clusterName) {
        super(clusterName, PIPELINE_NAME);
        this._externalViewCache = new PropertyCache<ExternalView>(this, "ExternalView", new PropertyCache.PropertyCacheKeyFuncs<ExternalView>(){

            @Override
            public PropertyKey getRootKey(HelixDataAccessor accessor) {
                return accessor.keyBuilder().externalViews();
            }

            @Override
            public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
                return accessor.keyBuilder().externalView(objName);
            }

            @Override
            public String getObjName(ExternalView obj) {
                return obj.getResourceName();
            }
        }, true);
        this._targetExternalViewCache = new PropertyCache<ExternalView>(this, "TargetExternalView", new PropertyCache.PropertyCacheKeyFuncs<ExternalView>(){

            @Override
            public PropertyKey getRootKey(HelixDataAccessor accessor) {
                return accessor.keyBuilder().targetExternalViews();
            }

            @Override
            public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
                return accessor.keyBuilder().targetExternalView(objName);
            }

            @Override
            public String getObjName(ExternalView obj) {
                return obj.getResourceName();
            }
        }, true);
        this._resourceAssignmentCache = new HashMap<String, ResourceAssignment>();
        this._idealMappingCache = new HashMap<String, ZNRecord>();
        this._missingTopStateMap = new HashMap<String, Map<String, MissingTopStateRecord>>();
        this._lastTopStateLocationMap = new HashMap<String, Map<String, String>>();
        this._refreshedChangeTypes = ConcurrentHashMap.newKeySet();
        this._customizedStateCache = new CustomizedStateCache(this, this._aggregationEnabledTypes);
        this._customizedViewCacheMap = new HashMap<String, CustomizedViewCache>();
    }

    @Override
    public synchronized void refresh(HelixDataAccessor accessor) {
        long startTime = System.currentTimeMillis();
        Set<HelixConstants.ChangeType> changedTypes = super.doRefresh(accessor);
        this._refreshedChangeTypes.addAll(changedTypes);
        if (changedTypes.contains((Object)HelixConstants.ChangeType.IDEAL_STATE) || changedTypes.contains((Object)HelixConstants.ChangeType.LIVE_INSTANCE) || changedTypes.contains((Object)HelixConstants.ChangeType.INSTANCE_CONFIG) || changedTypes.contains((Object)HelixConstants.ChangeType.RESOURCE_CONFIG) || changedTypes.contains((Object)HelixConstants.ChangeType.CLUSTER_CONFIG)) {
            this.clearCachedResourceAssignments();
        }
        this.refreshCustomizedStateConfig(accessor);
        this._customizedStateCache.setAggregationEnabledTypes(this._aggregationEnabledTypes);
        this._customizedStateCache.refresh(accessor, this.getLiveInstanceCache().getPropertyMap());
        this.refreshExternalViews(accessor);
        this.refreshTargetExternalViews(accessor);
        this.refreshCustomizedViewMap(accessor);
        this.refreshStablePartitionList(this.getIdealStates());
        this.refreshDisabledInstancesForAllPartitionsSet();
        if (this.getClusterConfig().getGlobalMaxPartitionAllowedPerInstance() != -1) {
            this.buildSimpleCapacityMap(this.getClusterConfig().getGlobalMaxPartitionAllowedPerInstance());
            Set cachedGreedyIdealStates = this._idealMappingCache.values().stream().filter(record -> record.getSimpleField(IdealState.IdealStateProperty.REBALANCE_STRATEGY.name()).equals(GreedyRebalanceStrategy.class.getName())).map(ZNRecord::getId).collect(Collectors.toSet());
            this._idealMappingCache.keySet().removeAll(cachedGreedyIdealStates);
        }
        LogUtil.logInfo(logger, this.getClusterEventId(), String.format("END: ResourceControllerDataProvider.refresh() for cluster %s, started at %d took %d for %s pipeline", this.getClusterName(), startTime, System.currentTimeMillis() - startTime, this.getPipelineName()));
        this.dumpDebugInfo();
    }

    @Override
    protected void dumpDebugInfo() {
        super.dumpDebugInfo();
        if (logger.isTraceEnabled()) {
            logger.trace("Cache content: " + this.toString());
        }
    }

    private void refreshCustomizedStateConfig(HelixDataAccessor accessor) {
        if (((AtomicBoolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.CUSTOMIZED_STATE_CONFIG)).getAndSet(false)) {
            CustomizedStateConfig customizedStateConfig = (CustomizedStateConfig)accessor.getProperty(accessor.keyBuilder().customizedStateConfig());
            if (customizedStateConfig != null) {
                this._aggregationEnabledTypes = new HashSet<String>(customizedStateConfig.getAggregationEnabledTypes());
            } else {
                this._aggregationEnabledTypes.clear();
            }
            LogUtil.logInfo(logger, this.getClusterEventId(), String.format("Reloaded CustomizedStateConfig for cluster %s, %s pipeline.", this.getClusterName(), this.getPipelineName()));
        } else {
            LogUtil.logInfo(logger, this.getClusterEventId(), String.format("No customized state config change for %s cluster, %s pipeline", this.getClusterName(), this.getPipelineName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshExternalViews(HelixDataAccessor accessor) {
        if (((AtomicBoolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.EXTERNAL_VIEW)).getAndSet(false)) {
            PropertyCache<ExternalView> propertyCache = this._externalViewCache;
            synchronized (propertyCache) {
                this._externalViewCache.refresh(accessor);
            }
        }
    }

    private void refreshTargetExternalViews(HelixDataAccessor accessor) {
        if (((AtomicBoolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.TARGET_EXTERNAL_VIEW)).getAndSet(false) && this.getClusterConfig() != null && this.getClusterConfig().isTargetExternalViewEnabled()) {
            this._targetExternalViewCache.refresh(accessor);
        }
    }

    public void refreshCustomizedViewMap(HelixDataAccessor accessor) {
        if (((AtomicBoolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.CUSTOMIZED_VIEW)).getAndSet(false)) {
            for (String stateType : this._aggregationEnabledTypes) {
                if (!this._customizedViewCacheMap.containsKey(stateType)) {
                    CustomizedViewCache newCustomizedViewCache = new CustomizedViewCache(this.getClusterName(), stateType);
                    this._customizedViewCacheMap.put(stateType, newCustomizedViewCache);
                }
                this._customizedViewCacheMap.get(stateType).refresh(accessor);
            }
            HashSet<String> previousCachedStateTypes = new HashSet<String>(this._customizedViewCacheMap.keySet());
            previousCachedStateTypes.removeAll(this._aggregationEnabledTypes);
            logger.info("Remove customizedView for state: " + previousCachedStateTypes);
            this.removeCustomizedViewTypes(previousCachedStateTypes);
        }
    }

    public Map<String, CustomizedState> getCustomizedState(String instanceName, String customizedStateType) {
        return this._customizedStateCache.getParticipantState(instanceName, customizedStateType);
    }

    public Set<String> getAggregationEnabledCustomizedStateTypes() {
        return this._aggregationEnabledTypes;
    }

    protected void setAggregationEnabledCustomizedStateTypes(Set<String> aggregationEnabledTypes) {
        this._aggregationEnabledTypes = aggregationEnabledTypes;
    }

    public ExternalView getTargetExternalView(String resourceName) {
        return this._targetExternalViewCache.getPropertyByName(resourceName);
    }

    public void updateTargetExternalView(String resourceName, ExternalView targetExternalView) {
        this._targetExternalViewCache.setProperty(targetExternalView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ExternalView> getExternalViews() {
        PropertyCache<ExternalView> propertyCache = this._externalViewCache;
        synchronized (propertyCache) {
            return this._externalViewCache.getPropertyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExternalViews(List<ExternalView> externalViews) {
        PropertyCache<ExternalView> propertyCache = this._externalViewCache;
        synchronized (propertyCache) {
            for (ExternalView ev : externalViews) {
                this._externalViewCache.setProperty(ev);
            }
        }
    }

    public void updateCustomizedViews(String customizedStateType, List<CustomizedView> customizedViews) {
        if (!this._customizedViewCacheMap.containsKey(customizedStateType)) {
            CustomizedViewCache customizedViewCache = new CustomizedViewCache(this.getClusterName(), customizedStateType);
            this._customizedViewCacheMap.put(customizedStateType, customizedViewCache);
        }
        for (CustomizedView cv : customizedViews) {
            this._customizedViewCacheMap.get(customizedStateType).getCustomizedViewCache().setProperty(cv);
        }
    }

    public Map<String, CustomizedViewCache> getCustomizedViewCacheMap() {
        return this._customizedViewCacheMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExternalViews(List<String> resourceNames) {
        PropertyCache<ExternalView> propertyCache = this._externalViewCache;
        synchronized (propertyCache) {
            for (String resourceName : resourceNames) {
                this._externalViewCache.deletePropertyByName(resourceName);
            }
        }
    }

    public void removeCustomizedViewTypes(Set<String> stateTypeNames) {
        for (String stateType : stateTypeNames) {
            this._customizedViewCacheMap.remove(stateType);
        }
    }

    public void removeCustomizedViews(String stateType, List<String> resourceNames) {
        if (!this._customizedViewCacheMap.containsKey(stateType)) {
            logger.warn(String.format("The customized state type : %s is not in the cache", stateType));
            return;
        }
        for (String resourceName : resourceNames) {
            this._customizedViewCacheMap.get(stateType).getCustomizedViewCache().deletePropertyByName(resourceName);
        }
    }

    public Map<String, Map<String, MissingTopStateRecord>> getMissingTopStateMap() {
        return this._missingTopStateMap;
    }

    public Map<String, Map<String, String>> getLastTopStateLocationMap() {
        return this._lastTopStateLocationMap;
    }

    public ResourceAssignment getCachedResourceAssignment(String resource) {
        return this._resourceAssignmentCache.get(resource);
    }

    public Map<String, ResourceAssignment> getCachedResourceAssignments() {
        return Collections.unmodifiableMap(this._resourceAssignmentCache);
    }

    public void setCachedResourceAssignment(String resource, ResourceAssignment resourceAssignment) {
        this._resourceAssignmentCache.put(resource, resourceAssignment);
    }

    public ZNRecord getCachedIdealMapping(String resource) {
        return this._idealMappingCache.get(resource);
    }

    public void invalidateCachedIdealStateMapping(String resource) {
        this._idealMappingCache.remove(resource);
    }

    public Map<String, ZNRecord> getCachedIdealMapping() {
        return Collections.unmodifiableMap(this._idealMappingCache);
    }

    public void setCachedIdealMapping(String resource, ZNRecord mapping) {
        this._idealMappingCache.put(resource, mapping);
    }

    public Set<HelixConstants.ChangeType> getRefreshedChangeTypes() {
        return this._refreshedChangeTypes;
    }

    public void clearRefreshedChangeTypes() {
        this._refreshedChangeTypes.clear();
    }

    public void clearCachedResourceAssignments() {
        this._resourceAssignmentCache.clear();
        this._idealMappingCache.clear();
    }

    public void clearMonitoringRecords() {
        this._missingTopStateMap.clear();
        this._lastTopStateLocationMap.clear();
    }

    public List<String> getStablePartitionList(String resourceName) {
        return this._stablePartitionListCache.get(resourceName);
    }

    final void refreshStablePartitionList(Map<String, IdealState> idealStateMap) {
        this._stablePartitionListCache.keySet().retainAll(idealStateMap.keySet());
        for (String resourceName : idealStateMap.keySet()) {
            Set<String> newPartitionSet = idealStateMap.get(resourceName).getPartitionSet();
            List<String> cachedPartitionList = this.getStablePartitionList(resourceName);
            if (cachedPartitionList != null && cachedPartitionList.size() == newPartitionSet.size() && newPartitionSet.containsAll(cachedPartitionList)) continue;
            this._stablePartitionListCache.put(resourceName, new ArrayList<String>(newPartitionSet));
        }
    }

    public void setWagedCapacityProviders(WagedInstanceCapacity capacityProvider, WagedResourceWeightsProvider resourceWeightProvider) {
        this._wagedInstanceCapacity = capacityProvider;
        this._wagedPartitionWeightProvider = resourceWeightProvider;
    }

    public boolean checkAndReduceCapacity(String instance, String resourceName, String partition) {
        if (this._wagedPartitionWeightProvider == null || this._wagedInstanceCapacity == null) {
            return true;
        }
        Map<String, Integer> partitionWeightMap = this._wagedPartitionWeightProvider.getPartitionWeights(resourceName, partition);
        if (partitionWeightMap == null || partitionWeightMap.isEmpty()) {
            return true;
        }
        return this._wagedInstanceCapacity.checkAndReduceInstanceCapacity(instance, resourceName, partition, partitionWeightMap);
    }

    public WagedInstanceCapacity getWagedInstanceCapacity() {
        return this._wagedInstanceCapacity;
    }

    private void buildSimpleCapacityMap(int globalMaxPartitionAllowedPerInstance) {
        this._simpleCapacitySet = new HashSet<CapacityNode>();
        for (String instance : this.getEnabledLiveInstances()) {
            CapacityNode capacityNode = new CapacityNode(instance);
            capacityNode.setCapacity(globalMaxPartitionAllowedPerInstance);
            this._simpleCapacitySet.add(capacityNode);
        }
    }

    public Set<CapacityNode> getSimpleCapacitySet() {
        return this._simpleCapacitySet;
    }

    private void refreshDisabledInstancesForAllPartitionsSet() {
        this._disabledInstancesForAllPartitionsSet.clear();
        Collection<InstanceConfig> allConfigs = this.getInstanceConfigMap().values();
        for (InstanceConfig config : allConfigs) {
            Map<String, List<String>> disabledPartitionMap = config.getDisabledPartitionsMap();
            if (!disabledPartitionMap.containsKey("ALL_RESOURCES")) continue;
            this._disabledInstancesForAllPartitionsSet.add(config.getInstanceName());
        }
    }

    @Override
    public Set<String> getDisabledInstancesForPartition(String resource, String partition) {
        Set<String> disabledInstances = super.getDisabledInstancesForPartition(resource, partition);
        disabledInstances.addAll(this._disabledInstancesForAllPartitionsSet);
        return disabledInstances;
    }
}

