/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.compress;

import com.clickhouse.client.internal.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import com.clickhouse.client.internal.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import com.clickhouse.client.internal.apache.commons.compress.compressors.deflate.DeflateParameters;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseCompressionAlgorithm;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.stream.WrappedInputStream;
import com.clickhouse.data.stream.WrappedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

@Deprecated
public final class DeflateSupport {
    private static int normalize(int level) {
        return level < 0 || level > 9 ? 1 : level;
    }

    public static ClickHouseCompressionAlgorithm getInstance() {
        return Factory.instance;
    }

    private DeflateSupport() {
    }

    static final class Factory {
        private static final ClickHouseCompressionAlgorithm instance = ClickHouseCompressionAlgorithm.createInstance("deflate_lib_detection", PreferredImpl.class, DefaultImpl.class);

        private Factory() {
        }
    }

    public static class PreferredImpl
    implements ClickHouseCompressionAlgorithm {
        public PreferredImpl() {
            new DeflateParameters();
        }

        @Override
        public ClickHouseOutputStream compress(ClickHousePassThruStream stream, OutputStream output, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            DeflateParameters params = new DeflateParameters();
            params.setWithZlibHeader(true);
            params.setCompressionLevel(DeflateSupport.normalize(level));
            return new WrappedOutputStream(stream, new DeflateCompressorOutputStream(output, params), bufferSize, postCloseAction);
        }

        @Override
        public ClickHouseInputStream decompress(ClickHousePassThruStream stream, InputStream input, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            DeflateParameters params = new DeflateParameters();
            params.setWithZlibHeader(true);
            params.setCompressionLevel(DeflateSupport.normalize(level));
            return new WrappedInputStream(stream, new DeflateCompressorInputStream(input, params), bufferSize, postCloseAction);
        }

        @Override
        public ClickHouseCompression getAlgorithm() {
            return ClickHouseCompression.DEFLATE;
        }
    }

    public static class DefaultImpl
    implements ClickHouseCompressionAlgorithm {
        @Override
        public ClickHouseOutputStream compress(ClickHousePassThruStream stream, OutputStream output, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            return new WrappedOutputStream(stream, new DeflaterOutputStream(output), bufferSize, postCloseAction);
        }

        @Override
        public ClickHouseInputStream decompress(ClickHousePassThruStream stream, InputStream input, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            return new WrappedInputStream(stream, new InflaterInputStream(input), bufferSize, postCloseAction);
        }

        @Override
        public ClickHouseCompression getAlgorithm() {
            return ClickHouseCompression.DEFLATE;
        }
    }
}

