/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.security.SecureRandom;
import java.util.Random;

public class Uuid4Util {
    private static Random random;
    private static final char[] DIGITS;

    public Uuid4Util() {
        try {
            random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        }
        catch (Exception e) {
            random = new Random();
        }
    }

    private byte[] getBytes() {
        byte[] raw = new byte[16];
        random.nextBytes(raw);
        raw[6] = (byte)(raw[6] & 0xF);
        raw[6] = (byte)(raw[6] | 0x40);
        raw[8] = (byte)(raw[8] & 0x3F);
        raw[8] = (byte)(raw[8] | 0x80);
        return raw;
    }

    private String getUUIDString(byte[] raw) {
        StringBuilder buf = new StringBuilder(new String(Uuid4Util.encodeHex(raw)));
        while (buf.length() != 32) {
            buf.insert(0, "0");
        }
        buf.ensureCapacity(32);
        buf.insert(8, '-');
        buf.insert(13, '-');
        buf.insert(18, '-');
        buf.insert(23, '-');
        return buf.toString();
    }

    private static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }

    public String getUUID4AsString() {
        return this.getUUIDString(this.getBytes());
    }

    static {
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

