/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.plugin.IVfs;
import org.apache.hop.core.vfs.plugin.VfsPlugin;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.vfs.azure.AzureFileProvider;
import org.apache.hop.vfs.azure.metadatatype.AzureMetadataType;

@VfsPlugin(type="azure", typeDescription="Azure VFS plugin", classLoaderGroup="vfs-azure")
public class AzureVfsPlugin
implements IVfs {
    public String[] getUrlSchemes() {
        return new String[]{"azure", "azfs"};
    }

    public FileProvider getProvider() {
        return new AzureFileProvider();
    }

    public Map<String, FileProvider> getProviders(IVariables variables) {
        HashMap<String, FileProvider> providers = new HashMap<String, FileProvider>();
        try {
            MultiMetadataProvider metadataProvider = HopMetadataUtil.getStandardHopMetadataProvider((IVariables)variables);
            List azureMetadataTypes = metadataProvider.getSerializer(AzureMetadataType.class).loadAll();
            for (AzureMetadataType azureMetadataType : azureMetadataTypes) {
                providers.put(azureMetadataType.getName(), (FileProvider)new AzureFileProvider(variables, azureMetadataType));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return providers;
    }
}

