/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.io.Serializable;
import java.util.UUID;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.Preconditions;

public abstract class FencedRpcEndpoint<F extends Serializable>
extends RpcEndpoint {
    private final F fencingToken;

    protected FencedRpcEndpoint(RpcService rpcService, String endpointId, F fencingToken) {
        super(rpcService, endpointId);
        Preconditions.checkNotNull(fencingToken, (String)"The fence token should be null");
        Preconditions.checkNotNull((Object)this.rpcServer, (String)"The rpc server should be null");
        this.fencingToken = fencingToken;
    }

    protected FencedRpcEndpoint(RpcService rpcService, F fencingToken) {
        this(rpcService, UUID.randomUUID().toString(), fencingToken);
    }

    public F getFencingToken() {
        return this.fencingToken;
    }
}

