/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableConstraints;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV2;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV3;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicDestinationsHelpers {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DynamicDestinationsHelpers.class);

    DynamicDestinationsHelpers() {
    }

    static <T, DestinationT> @UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> matchTableDynamicDestinations(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> inner, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        return new MatchTableDynamicDestinations(inner, bqServices);
    }

    static class MatchTableDynamicDestinations<@UnknownKeyFor T, @UnknownKeyFor DestinationT>
    extends DelegatingDynamicDestinations<T, DestinationT> {
        private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;

        private MatchTableDynamicDestinations(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> inner, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
            super(inner);
            this.bqServices = bqServices;
        }

        private @Nullable @UnknownKeyFor @Initialized Table getBigQueryTable(@UnknownKeyFor @NonNull @Initialized TableReference tableReference) {
            BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.withMaxRetries(3).withInitialBackoff(Duration.standardSeconds((long)1L)).withMaxBackoff(Duration.standardSeconds((long)2L)).backoff());
            while (true) {
                Table table;
                block16: {
                    PipelineOptions options = this.getPipelineOptions();
                    if (options == null) {
                        throw new IllegalStateException("pipeline options cannot be null");
                    }
                    BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
                    if (tableReference.getProjectId() == null) {
                        tableReference.setProjectId(bqOptions.getBigQueryProject() == null ? bqOptions.getProject() : bqOptions.getBigQueryProject());
                    }
                    BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService(bqOptions);
                    try {
                        table = datasetService.getTable(tableReference);
                        if (datasetService == null) break block16;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                try {
                                    if (datasetService != null) {
                                        try {
                                            datasetService.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException | InterruptedException e) {
                                    LOG.info("Failed to get BigQuery table " + tableReference);
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            if (MatchTableDynamicDestinations.nextBackOff(Sleeper.DEFAULT, backoff)) continue;
                            break;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    datasetService.close();
                }
                return table;
                break;
            }
            return null;
        }

        private static @UnknownKeyFor @NonNull @Initialized boolean nextBackOff(@UnknownKeyFor @NonNull @Initialized Sleeper sleeper, @UnknownKeyFor @NonNull @Initialized BackOff backoff) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            try {
                return BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableDestination getTable(DestinationT destination) {
            TableDestination wrappedDestination = super.getTable(destination);
            Table existingTable = this.getBigQueryTable(wrappedDestination.getTableReference());
            if (existingTable == null) {
                return wrappedDestination;
            }
            return new TableDestination(wrappedDestination.getTableSpec(), existingTable.getDescription(), existingTable.getTimePartitioning(), existingTable.getClustering());
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized TableSchema getSchema(DestinationT destination) {
            TableDestination wrappedDestination = super.getTable(destination);
            @Nullable Table existingTable = this.getBigQueryTable(wrappedDestination.getTableReference());
            if (existingTable == null || existingTable.getSchema() == null || existingTable.getSchema().isEmpty()) {
                return super.getSchema(destination);
            }
            return existingTable.getSchema();
        }
    }

    static class SchemaFromViewDestinations<@UnknownKeyFor T>
    extends DelegatingDynamicDestinations<T, TableDestination> {
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> schemaView;

        SchemaFromViewDestinations(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, @UnknownKeyFor @NonNull @Initialized TableDestination> inner, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> schemaView) {
            super(inner);
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((schemaView != null ? 1 : 0) != 0, (Object)"schemaView can not be null");
            this.schemaView = schemaView;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
            return ImmutableList.builder().add(this.schemaView).build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableSchema getSchema(@UnknownKeyFor @NonNull @Initialized TableDestination destination) {
            Map<String, String> mapValue = this.sideInput(this.schemaView);
            String schema = mapValue.get(destination.getTableSpec());
            Preconditions.checkArgumentNotNull((Object)schema, (String)"Schema view must contain data for every destination used, but view %s does not contain data for table destination %s produced by %s", this.schemaView, (Object)destination.getTableSpec(), (Object)this.inner);
            return BigQueryHelpers.fromJsonString(schema, TableSchema.class);
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inner", (Object)this.inner).add("schemaView", this.schemaView).toString();
        }
    }

    static class ConstantTimePartitioningClusteringDestinations<@UnknownKeyFor T>
    extends DelegatingDynamicDestinations<T, TableDestination> {
        private final @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> jsonTimePartitioning;
        private final @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> jsonClustering;

        ConstantTimePartitioningClusteringDestinations(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, @UnknownKeyFor @NonNull @Initialized TableDestination> inner, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> jsonTimePartitioning, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> jsonClustering) {
            super(inner);
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((jsonTimePartitioning != null && jsonTimePartitioning.isAccessible() && jsonTimePartitioning.get() != null || jsonClustering != null && jsonClustering.isAccessible() && jsonClustering.get() != null ? 1 : 0) != 0, (Object)"at least one of jsonTimePartitioning or jsonClustering must be non-null, accessible and present");
            this.jsonTimePartitioning = jsonTimePartitioning;
            this.jsonClustering = jsonClustering;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableDestination getDestination(@Nullable @UnknownKeyFor @Initialized ValueInSingleWindow<T> element) {
            String clustering;
            TableDestination destination = (TableDestination)super.getDestination(element);
            String partitioning = Optional.ofNullable(this.jsonTimePartitioning).map(ValueProvider::get).orElse(null);
            if (partitioning == null || JsonParser.parseString((String)partitioning).getAsJsonObject().isEmpty()) {
                partitioning = destination.getJsonTimePartitioning();
            }
            if ((clustering = (String)Optional.ofNullable(this.jsonClustering).map(ValueProvider::get).orElse(null)) == null || JsonParser.parseString((String)clustering).getAsJsonObject().isEmpty()) {
                clustering = destination.getJsonClustering();
            }
            return new TableDestination(destination.getTableSpec(), destination.getTableDescription(), partitioning, clustering);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized TableDestination> getDestinationCoder() {
            if (this.jsonClustering != null) {
                return TableDestinationCoderV3.of();
            }
            return TableDestinationCoderV2.of();
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("inner", (Object)this.inner);
            if (this.jsonTimePartitioning != null) {
                helper.add("jsonTimePartitioning", this.jsonTimePartitioning);
            }
            if (this.jsonClustering != null) {
                helper.add("jsonClustering", this.jsonClustering);
            }
            return helper.toString();
        }
    }

    static class ConstantSchemaDestinations<@UnknownKeyFor T, @UnknownKeyFor DestinationT>
    extends DelegatingDynamicDestinations<T, DestinationT> {
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> jsonSchema;

        ConstantSchemaDestinations(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> inner, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> jsonSchema) {
            super(inner);
            Preconditions.checkArgumentNotNull(jsonSchema, (Object)"jsonSchema can not be null");
            this.jsonSchema = jsonSchema;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableSchema getSchema(DestinationT destination) {
            String jsonSchema = (String)this.jsonSchema.get();
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((jsonSchema != null ? 1 : 0) != 0, (Object)"jsonSchema can not be null");
            return BigQueryHelpers.fromJsonString(jsonSchema, TableSchema.class);
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inner", (Object)this.inner).add("jsonSchema", this.jsonSchema).toString();
        }
    }

    static class ConstantTableConstraintsDestinations<@UnknownKeyFor T, @UnknownKeyFor DestinationT>
    extends DelegatingDynamicDestinations<T, DestinationT> {
        private final @UnknownKeyFor @NonNull @Initialized String jsonTableConstraints;

        ConstantTableConstraintsDestinations(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> inner, @UnknownKeyFor @NonNull @Initialized TableConstraints tableConstraints) {
            super(inner);
            this.jsonTableConstraints = BigQueryHelpers.toJsonString(tableConstraints);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableConstraints getTableConstraints(DestinationT destination) {
            return BigQueryHelpers.fromJsonString(this.jsonTableConstraints, TableConstraints.class);
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inner", (Object)this.inner).add("tableConstraints", (Object)this.jsonTableConstraints).toString();
        }
    }

    static class DelegatingDynamicDestinations<@UnknownKeyFor T, @UnknownKeyFor DestinationT>
    extends DynamicDestinations<T, DestinationT> {
        final @UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> inner;

        DelegatingDynamicDestinations(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> inner) {
            this.inner = inner;
        }

        @Override
        public DestinationT getDestination(@Nullable @UnknownKeyFor @Initialized ValueInSingleWindow<T> element) {
            return this.inner.getDestination(element);
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized TableSchema getSchema(DestinationT destination) {
            return this.inner.getSchema(destination);
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized TableConstraints getTableConstraints(DestinationT destination) {
            return this.inner.getTableConstraints(destination);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableDestination getTable(DestinationT destination) {
            return this.inner.getTable(destination);
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Coder<DestinationT> getDestinationCoder() {
            return this.inner.getDestinationCoder();
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> getDestinationCoderWithDefault(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            Coder<DestinationT> destinationCoder = this.getDestinationCoder();
            if (destinationCoder != null) {
                return destinationCoder;
            }
            return this.inner.getDestinationCoderWithDefault(registry);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
            return this.inner.getSideInputs();
        }

        @Override
        void setSideInputAccessorFromProcessContext(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            super.setSideInputAccessorFromProcessContext(context);
            this.inner.setSideInputAccessorFromProcessContext(context);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inner", this.inner).toString();
        }
    }

    static class TableFunctionDestinations<@UnknownKeyFor T>
    extends DynamicDestinations<T, TableDestination> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@Nullable @UnknownKeyFor @Initialized ValueInSingleWindow<T>, @UnknownKeyFor @NonNull @Initialized TableDestination> tableFunction;
        private final @UnknownKeyFor @NonNull @Initialized boolean clusteringEnabled;

        TableFunctionDestinations(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@Nullable @UnknownKeyFor @Initialized ValueInSingleWindow<T>, @UnknownKeyFor @NonNull @Initialized TableDestination> tableFunction, @UnknownKeyFor @NonNull @Initialized boolean clusteringEnabled) {
            this.tableFunction = tableFunction;
            this.clusteringEnabled = clusteringEnabled;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableDestination getDestination(@Nullable @UnknownKeyFor @Initialized ValueInSingleWindow<T> element) {
            TableDestination res = (TableDestination)this.tableFunction.apply(element);
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((res != null ? 1 : 0) != 0, (String)"result of tableFunction can not be null, but %s returned null for element: %s", this.tableFunction, element);
            return res;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized TableSchema getSchema(@UnknownKeyFor @NonNull @Initialized TableDestination destination) {
            return null;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableDestination getTable(@UnknownKeyFor @NonNull @Initialized TableDestination destination) {
            return destination;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized TableDestination> getDestinationCoder() {
            if (this.clusteringEnabled) {
                return TableDestinationCoderV3.of();
            }
            return TableDestinationCoderV2.of();
        }
    }

    static class ConstantTableDestinations<@UnknownKeyFor T>
    extends DynamicDestinations<T, TableDestination> {
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tableSpec;
        private final @Nullable @UnknownKeyFor @Initialized String tableDescription;
        private final @UnknownKeyFor @NonNull @Initialized boolean clusteringEnabled;

        ConstantTableDestinations(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tableSpec, @Nullable @UnknownKeyFor @Initialized String tableDescription, @UnknownKeyFor @NonNull @Initialized boolean clusteringEnabled) {
            this.tableSpec = tableSpec;
            this.tableDescription = tableDescription;
            this.clusteringEnabled = clusteringEnabled;
        }

        static <T> @UnknownKeyFor @NonNull @Initialized ConstantTableDestinations<T> fromTableSpec(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tableSpec, @UnknownKeyFor @NonNull @Initialized String tableDescription, @UnknownKeyFor @NonNull @Initialized boolean clusteringEnabled) {
            return new ConstantTableDestinations<T>(tableSpec, tableDescription, clusteringEnabled);
        }

        static <T> @UnknownKeyFor @NonNull @Initialized ConstantTableDestinations<T> fromJsonTableRef(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> jsonTableRef, @UnknownKeyFor @NonNull @Initialized String tableDescription, @UnknownKeyFor @NonNull @Initialized boolean clusteringEnabled) {
            return new ConstantTableDestinations<T>((ValueProvider<String>)ValueProvider.NestedValueProvider.of(jsonTableRef, (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableSpec()), tableDescription, clusteringEnabled);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableDestination getDestination(@Nullable @UnknownKeyFor @Initialized ValueInSingleWindow<T> element) {
            String tableSpec = (String)this.tableSpec.get();
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((tableSpec != null ? 1 : 0) != 0, (Object)"tableSpec can not be null");
            return new TableDestination(tableSpec, this.tableDescription);
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized TableSchema getSchema(@UnknownKeyFor @NonNull @Initialized TableDestination destination) {
            return null;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableDestination getTable(@UnknownKeyFor @NonNull @Initialized TableDestination destination) {
            return destination;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized TableDestination> getDestinationCoder() {
            if (this.clusteringEnabled) {
                return TableDestinationCoderV3.of();
            }
            return TableDestinationCoderV2.of();
        }
    }
}

