/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.api.Auth;
import com.bettercloud.vault.api.Debug;
import com.bettercloud.vault.api.Leases;
import com.bettercloud.vault.api.Logical;
import com.bettercloud.vault.api.pki.Pki;

public class Vault {
    private final VaultConfig vaultConfig;

    public Vault(VaultConfig vaultConfig) {
        this.vaultConfig = vaultConfig;
    }

    public Vault withRetries(int maxRetries, int retryIntervalMilliseconds) {
        this.vaultConfig.setMaxRetries(maxRetries);
        this.vaultConfig.setRetryIntervalMilliseconds(retryIntervalMilliseconds);
        return this;
    }

    public Logical logical() {
        return new Logical(this.vaultConfig);
    }

    public Auth auth() {
        return new Auth(this.vaultConfig);
    }

    public Pki pki() {
        return new Pki(this.vaultConfig);
    }

    public Pki pki(String mountPath) {
        return new Pki(this.vaultConfig, mountPath);
    }

    public Leases leases() {
        return new Leases(this.vaultConfig);
    }

    public Debug debug() {
        return new Debug(this.vaultConfig);
    }
}

