/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.SynchronousFileIOChannel;
import org.apache.flink.runtime.io.network.buffer.Buffer;

public class SynchronousBufferFileReader
extends SynchronousFileIOChannel
implements BufferFileReader {
    private final BufferFileChannelReader reader;
    private boolean hasReachedEndOfFile;

    public SynchronousBufferFileReader(FileIOChannel.ID channelID, boolean writeEnabled) throws IOException {
        super(channelID, writeEnabled);
        this.reader = new BufferFileChannelReader(this.fileChannel);
    }

    @Override
    public void readInto(Buffer buffer) throws IOException {
        if (this.fileChannel.size() - this.fileChannel.position() > 0L) {
            this.hasReachedEndOfFile = this.reader.readBufferFromFileChannel(buffer);
        } else {
            buffer.recycleBuffer();
        }
    }

    @Override
    public void seekToPosition(long position) throws IOException {
        this.fileChannel.position(position);
    }

    @Override
    public boolean hasReachedEndOfFile() {
        return this.hasReachedEndOfFile;
    }
}

