/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.hadoop.util.Time;
import org.apache.hive.jdbc.Utils;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.CookieStore;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpRequestInterceptorBase
implements HttpRequestInterceptor {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    CookieStore cookieStore;
    boolean isCookieEnabled;
    String cookieName;
    boolean isSSL;
    Map<String, String> additionalHeaders;
    Map<String, String> customCookies;
    private Supplier<String> sessionId = null;
    private boolean requestTrackingEnabled;
    private final AtomicLong requestTrackCounter = new AtomicLong();

    protected abstract void addHttpAuthHeader(HttpRequest var1, HttpContext var2) throws Exception;

    public HttpRequestInterceptorBase(CookieStore cs, String cn, boolean isSSL, Map<String, String> additionalHeaders, Map<String, String> customCookies) {
        this.cookieStore = cs;
        this.isCookieEnabled = cs != null;
        this.cookieName = cn;
        this.isSSL = isSSL;
        this.additionalHeaders = additionalHeaders == null ? new HashMap() : additionalHeaders;
        this.customCookies = customCookies;
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        try {
            if (!this.isCookieEnabled || httpContext.getAttribute("hive.server2.retryserver") == null && (this.cookieStore == null || this.cookieStore != null && Utils.needToSendCredentials(this.cookieStore, this.cookieName, this.isSSL)) || httpContext.getAttribute("hive.server2.retryserver") != null && httpContext.getAttribute("hive.server2.retryserver").equals("true")) {
                this.addHttpAuthHeader(httpRequest, httpContext);
                httpContext.setAttribute("hive.server2.sentCredentials", (Object)"true");
            } else {
                httpContext.setAttribute("hive.server2.sentCredentials", (Object)"false");
            }
            if (this.isCookieEnabled) {
                httpContext.setAttribute("hive.server2.retryserver", (Object)"false");
            }
            if (this.requestTrackingEnabled) {
                String trackHeader = this.getNewTrackHeader();
                this.LOG.info("{}:{}", (Object)"X-Request-ID", (Object)trackHeader);
                this.additionalHeaders.put("X-Request-ID", trackHeader);
                httpContext.setAttribute("X-Request-ID", (Object)trackHeader);
                httpContext.setAttribute((String)trackHeader + "_TIME", (Object)Time.monotonicNow());
            }
            if (this.additionalHeaders != null) {
                for (Map.Entry entry : this.additionalHeaders.entrySet()) {
                    httpRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (this.customCookies != null && !this.customCookies.isEmpty()) {
                String cookieHeaderKeyValues = "";
                Header header = httpRequest.getFirstHeader("Cookie");
                if (header != null && header.getValue() != null) {
                    cookieHeaderKeyValues = header.getValue();
                }
                for (Map.Entry<String, String> entry : this.customCookies.entrySet()) {
                    cookieHeaderKeyValues = cookieHeaderKeyValues + ";" + entry.getKey() + "=" + entry.getValue();
                }
                if (cookieHeaderKeyValues.startsWith(";")) {
                    cookieHeaderKeyValues = cookieHeaderKeyValues.substring(1);
                }
                httpRequest.addHeader("Cookie", cookieHeaderKeyValues);
            }
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getNewTrackHeader() {
        return String.format("HIVE_%s_%020d", this.sessionId.get(), this.requestTrackCounter.incrementAndGet());
    }

    public HttpRequestInterceptor sessionId(Supplier<String> sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public void setRequestTrackingEnabled(boolean requestTrackingEnabled) {
        this.requestTrackingEnabled = requestTrackingEnabled;
    }
}

