/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.errorhandling;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.auto.value.AutoValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.transforms.errorhandling.AutoValue_BadRecord;
import org.apache.beam.sdk.transforms.errorhandling.AutoValue_BadRecord_Failure;
import org.apache.beam.sdk.transforms.errorhandling.AutoValue_BadRecord_Record;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class BadRecord
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BadRecord.class);

    public abstract @UnknownKeyFor @NonNull @Initialized Record getRecord();

    public abstract @UnknownKeyFor @NonNull @Initialized Failure getFailure();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_BadRecord.Builder();
    }

    public static @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BadRecord> getCoder(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        try {
            SchemaRegistry schemaRegistry = pipeline.getSchemaRegistry();
            return SchemaCoder.of(schemaRegistry.getSchema(BadRecord.class), TypeDescriptor.of(BadRecord.class), schemaRegistry.getToRowFunction(BadRecord.class), schemaRegistry.getFromRowFunction(BadRecord.class));
        }
        catch (NoSuchSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    public static <RecordT> @UnknownKeyFor @NonNull @Initialized BadRecord fromExceptionInformation(RecordT record, @Nullable @UnknownKeyFor @Initialized Coder<RecordT> coder, @Nullable @UnknownKeyFor @Initialized Exception exception, @UnknownKeyFor @NonNull @Initialized String description) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkArgumentNotNull(record);
        Record.Builder recordBuilder = Record.builder();
        recordBuilder.addHumanReadableJson(record).addCoderAndEncodedRecord(coder, record);
        Failure.Builder failureBuilder = Failure.builder().setDescription(description);
        if (exception != null) {
            failureBuilder.setException(exception.toString()).addExceptionStackTrace(exception);
        }
        return BadRecord.builder().setRecord(recordBuilder.build()).setFailure(failureBuilder.build()).build();
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class Failure
    implements Serializable {
        public abstract @Nullable @UnknownKeyFor @Initialized String getException();

        public abstract @Nullable @UnknownKeyFor @Initialized String getExceptionStacktrace();

        public abstract @UnknownKeyFor @NonNull @Initialized String getDescription();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BadRecord_Failure.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setException(@Nullable @UnknownKeyFor @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setExceptionStacktrace(@Nullable @UnknownKeyFor @Initialized String var1);

            public @UnknownKeyFor @NonNull @Initialized Builder addExceptionStackTrace(@UnknownKeyFor @NonNull @Initialized Exception exception) throws @UnknownKeyFor @NonNull @Initialized IOException {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)stream, false, StandardCharsets.UTF_8.name());
                exception.printStackTrace(printStream);
                printStream.close();
                this.setExceptionStacktrace(new String(stream.toByteArray(), StandardCharsets.UTF_8));
                return this;
            }

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDescription(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Failure build();
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class Record
    implements Serializable {
        public abstract @Nullable @UnknownKeyFor @Initialized String getHumanReadableJsonRecord();

        public abstract @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getEncodedRecord();

        public abstract @Nullable @UnknownKeyFor @Initialized String getCoder();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BadRecord_Record.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setHumanReadableJsonRecord(@Nullable @UnknownKeyFor @Initialized String var1);

            public @UnknownKeyFor @NonNull @Initialized Builder addHumanReadableJson(@UnknownKeyFor @NonNull @Initialized Object record) {
                ObjectWriter objectWriter = new ObjectMapper().writer().withDefaultPrettyPrinter();
                try {
                    this.setHumanReadableJsonRecord(objectWriter.writeValueAsString(record));
                }
                catch (Exception e) {
                    LOG.error("Unable to serialize record as JSON. Human readable record attempted via .toString", (Throwable)e);
                    try {
                        this.setHumanReadableJsonRecord(record.toString());
                    }
                    catch (Exception e2) {
                        LOG.error("Unable to serialize record via .toString. Human readable record will be null", (Throwable)e2);
                    }
                }
                return this;
            }

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setEncodedRecord(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setCoder(@Nullable @UnknownKeyFor @Initialized String var1);

            public <T> @UnknownKeyFor @NonNull @Initialized Builder addCoderAndEncodedRecord(@Nullable @UnknownKeyFor @Initialized Coder<T> coder, T record) {
                if (coder != null) {
                    this.setCoder(coder.toString());
                    try {
                        this.setEncodedRecord(CoderUtils.encodeToByteArray(coder, record));
                    }
                    catch (IOException e) {
                        LOG.error("Unable to encode failing record using provided coder. BadRecord will be published without encoded bytes", (Throwable)e);
                    }
                }
                return this;
            }

            public abstract @UnknownKeyFor @NonNull @Initialized Record build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setRecord(@UnknownKeyFor @NonNull @Initialized Record var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFailure(@UnknownKeyFor @NonNull @Initialized Failure var1);

        public abstract @UnknownKeyFor @NonNull @Initialized BadRecord build();
    }
}

