/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.beam.sdk.extensions.gcp.util.channels.CountingReadableByteChannel;
import org.apache.beam.sdk.extensions.gcp.util.channels.CountingWritableByteChannel;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethodsIf;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CountingSeekableByteChannel
implements SeekableByteChannel {
    private final @UnknownKeyFor @NonNull @Initialized SeekableByteChannel delegate;
    private final @UnknownKeyFor @NonNull @Initialized WritableByteChannel writableDelegate;
    private final @UnknownKeyFor @NonNull @Initialized ReadableByteChannel readableDelegate;

    public static @UnknownKeyFor @NonNull @Initialized CountingSeekableByteChannel createWithBytesReadConsumer(@UnknownKeyFor @NonNull @Initialized SeekableByteChannel delegate, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Integer> bytesReadConsumer) {
        return new CountingSeekableByteChannel(delegate, bytesReadConsumer, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized CountingSeekableByteChannel createWithBytesWrittenConsumer(@UnknownKeyFor @NonNull @Initialized SeekableByteChannel delegate, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Integer> bytesWrittenConsumer) {
        return new CountingSeekableByteChannel(delegate, null, bytesWrittenConsumer);
    }

    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized CountingSeekableByteChannel createWithNoOpConsumer(@UnknownKeyFor @NonNull @Initialized SeekableByteChannel delegate) {
        Consumer<Integer> noop = __ -> {};
        return new CountingSeekableByteChannel(delegate, noop, noop);
    }

    public CountingSeekableByteChannel(@UnknownKeyFor @NonNull @Initialized SeekableByteChannel delegate, @Nullable @UnknownKeyFor @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Integer> bytesReadConsumer, @Nullable @UnknownKeyFor @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Integer> bytesWrittenConsumer) {
        this.delegate = (SeekableByteChannel)Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkArgument((bytesReadConsumer != null || bytesWrittenConsumer != null ? 1 : 0) != 0, (Object)"At least one of bytesReadConsumer or bytesWrittenConsumer must be non-null");
        this.readableDelegate = Optional.ofNullable(bytesReadConsumer).map(consumer -> new CountingReadableByteChannel(delegate, (Consumer<Integer>)consumer)).orElse(delegate);
        this.writableDelegate = Optional.ofNullable(bytesWrittenConsumer).map(consumer -> new CountingWritableByteChannel(delegate, (Consumer<Integer>)consumer)).orElse(delegate);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized ByteBuffer dst) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.readableDelegate.read(dst);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int write(@UnknownKeyFor @NonNull @Initialized ByteBuffer src) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.writableDelegate.write(src);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long position() throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.delegate.position();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SeekableByteChannel position(@UnknownKeyFor @NonNull @Initialized long newPosition) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.delegate.position(newPosition);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long size() throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.delegate.size();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SeekableByteChannel truncate(@UnknownKeyFor @NonNull @Initialized long size) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.delegate.truncate(size);
        return this;
    }

    @Override
    @EnsuresCalledMethodsIf(expression={"this"}, result=false, methods={"close"})
    public @UnknownKeyFor @NonNull @Initialized boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.delegate.close();
    }
}

