/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.metadata;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.json.JsonMetadataParser;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataProvider;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SerializableMetadataProvider
extends MemoryMetadataProvider
implements IHopMetadataProvider {
    public SerializableMetadataProvider() {
    }

    public SerializableMetadataProvider(IHopMetadataProvider source) throws HopException {
        this.description = "Serializable metadata provider (source is " + source.getDescription() + ")";
        for (Class metadataClass : source.getMetadataClasses()) {
            IHopMetadataSerializer sourceSerializer = source.getSerializer(metadataClass);
            IHopMetadataSerializer targetSerializer = this.getSerializer(metadataClass);
            for (String name : sourceSerializer.listObjectNames()) {
                targetSerializer.save(sourceSerializer.load(name));
            }
        }
    }

    public String toJson() throws HopException {
        JSONObject jStore = new JSONObject();
        for (Class metadataClass : this.getMetadataClasses()) {
            IHopMetadataSerializer serializer = this.getSerializer(metadataClass);
            HopMetadata hopMetadata = metadataClass.getAnnotation(HopMetadata.class);
            if (hopMetadata == null) {
                throw new HopException("Error: class " + String.valueOf(metadataClass) + " is not annotated with " + HopMetadata.class.getName());
            }
            String classKey = hopMetadata.key();
            JSONArray jClass = new JSONArray();
            JsonMetadataParser parser = new JsonMetadataParser(metadataClass, (IHopMetadataProvider)this);
            for (String name : serializer.listObjectNames()) {
                IHopMetadata object = serializer.load(name);
                JSONObject jObject = parser.getJsonObject(object);
                jClass.add((Object)jObject);
            }
            jStore.put((Object)classKey, (Object)jClass);
        }
        return jStore.toJSONString();
    }

    public SerializableMetadataProvider(String storeJson) throws HopException {
        this();
        this.description = "Serializable metadata provider (source is JSON)";
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(storeJson.getBytes(StandardCharsets.UTF_8));){
            JsonFactory jsonFactory = new JsonFactory();
            JsonParser jsonParser = jsonFactory.createParser((InputStream)inputStream);
            jsonParser.nextToken();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String classKey = jsonParser.getText();
                Class<IHopMetadata> managedClass = this.getManagedClass(classKey);
                if (managedClass == null) {
                    jsonParser.nextToken();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    }
                    continue;
                }
                JsonMetadataParser metadataParser = new JsonMetadataParser(managedClass, (IHopMetadataProvider)this);
                IHopMetadataSerializer serializer = this.getSerializer(managedClass);
                jsonParser.nextToken();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    IHopMetadata object = metadataParser.loadJsonObject(managedClass, jsonParser);
                    if (object == null) continue;
                    serializer.save(object);
                }
            }
        }
        catch (Exception e) {
            throw new HopException("Error reading metadata from JSON", (Throwable)e);
        }
    }

    private Class<IHopMetadata> getManagedClass(String classKey) {
        Class managedClass;
        try {
            managedClass = this.getMetadataClassForKey(classKey);
        }
        catch (HopException e) {
            LogChannel.GENERAL.logError("Error loading class " + classKey, (Throwable)e);
            managedClass = null;
        }
        return managedClass;
    }
}

