/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.truststore;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;

public class HopTrustManager
implements X509TrustManager {
    private static final Class<?> classFromPackage = HopTrustManager.class;
    private X509TrustManager tm;

    public HopTrustManager(KeyStore keyStore, String certFilename, String certPassword) throws HopException {
        try {
            InputStream inputStream = null;
            try {
                inputStream = HopVfs.getInputStream((String)certFilename);
                keyStore.load(inputStream, Const.NVL((String)certPassword, (String)"").toCharArray());
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(classFromPackage, (String)"HopTrustManager.Exception.CouldNotOpenCertStore", (String[])new String[0]), (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        throw new HopException(BaseMessages.getString(classFromPackage, (String)"HopTrustManager.Exception.CouldNotOpenCertStore", (String[])new String[0]), (Throwable)e);
                    }
                }
            }
            try {
                TrustManagerFactory tmf = null;
                tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(keyStore);
                TrustManager[] tms = tmf.getTrustManagers();
                this.tm = (X509TrustManager)tms[0];
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(classFromPackage, (String)"HopTrustManager.Exception.CouldNotInitializeTrustManager", (String[])new String[0]), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(classFromPackage, (String)"HopTrustManager.Exception.CouldNotInitializeHopTrustManager", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this.tm == null) {
            return null;
        }
        return this.tm.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.tm == null) {
            return;
        }
        this.tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.tm == null) {
            return;
        }
        this.tm.checkServerTrusted(chain, authType);
    }
}

