/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.action.copy;

import java.util.Map;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.pipeline.transform.copy.CopyContext;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.copy.IActionCopyFactory;

public class DefaultActionCopyFactory
implements IActionCopyFactory {
    private static final ILogChannel log = LogChannel.GENERAL;
    private static volatile DefaultActionCopyFactory instance;

    private DefaultActionCopyFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultActionCopyFactory getInstance() {
        if (instance != null) return instance;
        Class<DefaultActionCopyFactory> clazz = DefaultActionCopyFactory.class;
        synchronized (DefaultActionCopyFactory.class) {
            if (instance != null) return instance;
            instance = new DefaultActionCopyFactory();
            log.logDetailed("DefaultActionCopyFactory singleton instance created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public IAction copy(IAction source) {
        return this.copy(source, CopyContext.DEFAULT);
    }

    @Override
    public IAction copy(IAction source, CopyContext context) {
        if (source == null) {
            log.logDebug("Attempted to copy null action, returning null");
            return null;
        }
        if (context == null) {
            log.logDebug("Null context provided, using DEFAULT context");
            context = CopyContext.DEFAULT;
        }
        try {
            log.logRowlevel("Copying action: " + source.getClass().getSimpleName() + " with context: " + String.valueOf(context));
            boolean hadChanges = context.isPreserveChangedState() && source.hasChanged();
            IAction copy = (IAction)source.clone();
            if (copy == null) {
                log.logError("Clone operation returned null for action: " + source.getClass().getSimpleName());
                return null;
            }
            if (context.isPreserveChangedState() && hadChanges) {
                copy.setChanged();
                log.logRowlevel("Restored changed state to copied action");
            } else if (!context.isPreserveChangedState()) {
                copy.setChanged(false);
                log.logRowlevel("Cleared changed state for lightweight copy");
            }
            log.logRowlevel("Successfully copied action: " + source.getClass().getSimpleName());
            return copy;
        }
        catch (Exception e) {
            log.logError("Error copying action: " + source.getClass().getSimpleName(), (Throwable)e);
            try {
                return (IAction)source.clone();
            }
            catch (Exception fallbackException) {
                log.logError("Fallback clone also failed for action: " + source.getClass().getSimpleName(), (Throwable)fallbackException);
                return null;
            }
        }
    }

    @Override
    public ActionMeta copy(ActionMeta source) {
        return this.copy(source, CopyContext.DEFAULT);
    }

    @Override
    public ActionMeta copy(ActionMeta source, CopyContext context) {
        if (source == null) {
            log.logDebug("Attempted to copy null ActionMeta, returning null");
            return null;
        }
        if (context == null) {
            log.logDebug("Null context provided, using DEFAULT context");
            context = CopyContext.DEFAULT;
        }
        try {
            log.logRowlevel("Copying ActionMeta: " + (source.getAction() != null ? source.getAction().getClass().getSimpleName() : "null") + " with context: " + String.valueOf(context));
            ActionMeta copy = new ActionMeta();
            if (source.getAction() != null) {
                IAction actionCopy = this.copy(source.getAction(), context);
                copy.setAction(actionCopy);
            }
            copy.setSelected(source.isSelected());
            if (source.getLocation() != null) {
                copy.setLocation(source.getLocation().x, source.getLocation().y);
            }
            copy.setLaunchingInParallel(source.isLaunchingInParallel());
            if (source.getAttributesMap() != null) {
                for (Map.Entry entry : source.getAttributesMap().entrySet()) {
                    copy.getAttributesMap().put((String)entry.getKey(), (Map)entry.getValue());
                }
            }
            if (context == CopyContext.SAME_PIPELINE && source.getParentWorkflowMeta() != null) {
                copy.setParentWorkflowMeta(source.getParentWorkflowMeta());
            }
            if (context.isPreserveChangedState()) {
                copy.setChanged();
                log.logRowlevel("Set changed state on copied ActionMeta");
            }
            log.logRowlevel("Successfully copied ActionMeta");
            return copy;
        }
        catch (Exception e) {
            log.logError("Error copying ActionMeta: " + (source.getAction() != null ? source.getAction().getClass().getSimpleName() : "null"), (Throwable)e);
            try {
                return source.clone();
            }
            catch (Exception fallbackException) {
                log.logError("Fallback clone also failed for ActionMeta", (Throwable)fallbackException);
                return null;
            }
        }
    }
}

