/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;

@Experimental
public class CommittableSummary<CommT>
implements CommittableMessage<CommT> {
    private final int subtaskId;
    private final int numberOfSubtasks;
    @Nullable
    private final Long checkpointId;
    private final int numberOfCommittables;
    private final int numberOfPendingCommittables;
    private final int numberOfFailedCommittables;

    public CommittableSummary(int subtaskId, int numberOfSubtasks, @Nullable Long checkpointId, int numberOfCommittables, int numberOfPendingCommittables, int numberOfFailedCommittables) {
        this.subtaskId = subtaskId;
        this.numberOfSubtasks = numberOfSubtasks;
        this.checkpointId = checkpointId;
        this.numberOfCommittables = numberOfCommittables;
        this.numberOfPendingCommittables = numberOfPendingCommittables;
        this.numberOfFailedCommittables = numberOfFailedCommittables;
    }

    @Override
    public int getSubtaskId() {
        return this.subtaskId;
    }

    public int getNumberOfSubtasks() {
        return this.numberOfSubtasks;
    }

    @Override
    public OptionalLong getCheckpointId() {
        return this.checkpointId == null ? OptionalLong.empty() : OptionalLong.of(this.checkpointId);
    }

    public int getNumberOfCommittables() {
        return this.numberOfCommittables;
    }

    public int getNumberOfPendingCommittables() {
        return this.numberOfPendingCommittables;
    }

    public int getNumberOfFailedCommittables() {
        return this.numberOfFailedCommittables;
    }

    public <NewCommT> CommittableSummary<NewCommT> map() {
        return new CommittableSummary<CommT>(this.subtaskId, this.numberOfSubtasks, this.checkpointId, this.numberOfCommittables, this.numberOfPendingCommittables, this.numberOfFailedCommittables);
    }
}

