/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.guava31.com.google.common.collect.Lists;
import org.apache.flink.util.AbstractID;

@Internal
public class CacheTransformation<T>
extends Transformation<T> {
    private final Transformation<T> transformationToCache;
    private final AbstractID datasetId;
    private boolean isCached;

    public CacheTransformation(Transformation<T> transformationToCache, String name) {
        super(name, transformationToCache.getOutputType(), transformationToCache.getParallelism(), transformationToCache.isParallelismConfigured());
        this.transformationToCache = transformationToCache;
        this.datasetId = new AbstractID();
        this.isCached = false;
    }

    public List<Transformation<?>> getTransitivePredecessors() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        if (this.isCached) {
            return result;
        }
        result.addAll(this.transformationToCache.getTransitivePredecessors());
        return result;
    }

    public List<Transformation<?>> getInputs() {
        if (this.isCached) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.transformationToCache);
    }

    public AbstractID getDatasetId() {
        return this.datasetId;
    }

    public Transformation<T> getTransformationToCache() {
        return this.transformationToCache;
    }

    public void setCached(boolean cached) {
        this.isCached = cached;
    }

    public boolean isCached() {
        return this.isCached;
    }
}

