/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPIDOutQ;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.PrintObjectImplRemote;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RequestNotSupportedException;
import java.io.IOException;

class OutputQueueImplRemote
extends PrintObjectImplRemote
implements OutputQueueImpl {
    private static final NPCPAttributeIDList attrsToRetrieve_ = new NPCPAttributeIDList();
    private static boolean fAttrIDsToRtvBuilt_ = false;

    OutputQueueImplRemote() {
    }

    private synchronized void buildAttrIDsToRtv() {
        if (!fAttrIDsToRtvBuilt_) {
            attrsToRetrieve_.addAttrID(14);
            attrsToRetrieve_.addAttrID(32);
            attrsToRetrieve_.addAttrID(33);
            attrsToRetrieve_.addAttrID(41);
            attrsToRetrieve_.addAttrID(61);
            attrsToRetrieve_.addAttrID(69);
            attrsToRetrieve_.addAttrID(145);
            attrsToRetrieve_.addAttrID(70);
            attrsToRetrieve_.addAttrID(71);
            attrsToRetrieve_.addAttrID(73);
            attrsToRetrieve_.addAttrID(74);
            attrsToRetrieve_.addAttrID(75);
            attrsToRetrieve_.addAttrID(89);
            attrsToRetrieve_.addAttrID(96);
            attrsToRetrieve_.addAttrID(161);
            attrsToRetrieve_.addAttrID(109);
            attrsToRetrieve_.addAttrID(163);
            attrsToRetrieve_.addAttrID(165);
            attrsToRetrieve_.addAttrID(164);
            attrsToRetrieve_.addAttrID(166);
            attrsToRetrieve_.addAttrID(168);
            attrsToRetrieve_.addAttrID(167);
            attrsToRetrieve_.addAttrID(171);
            attrsToRetrieve_.addAttrID(170);
            attrsToRetrieve_.addAttrID(121);
            attrsToRetrieve_.addAttrID(122);
            attrsToRetrieve_.addAttrID(123);
            attrsToRetrieve_.addAttrID(124);
            fAttrIDsToRtvBuilt_ = true;
        }
    }

    private static NPCPIDOutQ buildIDCodePoint(String IFSQueueName) {
        QSYSObjectPathName ifsPath = new QSYSObjectPathName(IFSQueueName, "OUTQ");
        return new NPCPIDOutQ(ifsPath.getObjectName(), ifsPath.getLibraryName());
    }

    @Override
    public void clear(PrintParameterList clearOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream sendDS = new NPDataStream(4);
        NPDataStream returnDS = new NPDataStream(4);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        sendDS.setAction(21);
        sendDS.addCodePoint(this.getIDCodePoint());
        if (clearOptions != null) {
            NPCPAttribute selectionCP = new NPCPAttribute(clearOptions.getAttrCodePoint());
            selectionCP.setID(6);
            sendDS.addCodePoint(selectionCP);
        }
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
        this.updateAttrs(this.getAttrIDsToRetrieve());
    }

    @Override
    NPCPAttributeIDList getAttrIDsToRetrieve() {
        if (!fAttrIDsToRtvBuilt_) {
            this.buildAttrIDsToRtv();
        }
        return attrsToRetrieve_;
    }

    @Override
    NPCPAttributeIDList getAttrIDsToRetrieve(int attrToRtv) {
        if (!fAttrIDsToRtvBuilt_) {
            attrsToRetrieve_.addAttrID(attrToRtv);
        }
        return attrsToRetrieve_;
    }

    @Override
    public void hold() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream sendDS = new NPDataStream(4);
        NPDataStream returnDS = new NPDataStream(4);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        sendDS.setAction(6);
        sendDS.addCodePoint(this.getIDCodePoint());
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
        this.updateAttrs(this.getAttrIDsToRetrieve());
    }

    @Override
    public void release() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream sendDS = new NPDataStream(4);
        NPDataStream returnDS = new NPDataStream(4);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        sendDS.setAction(7);
        sendDS.addCodePoint(this.getIDCodePoint());
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
        this.updateAttrs(this.getAttrIDsToRetrieve());
    }
}

