/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ActiveStatusEvent;
import com.ibm.as400.resource.ActiveStatusListener;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceLevel;
import com.ibm.as400.resource.ResourceListEnumeration;
import com.ibm.as400.resource.ResourceListEvent;
import com.ibm.as400.resource.ResourceListListener;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ResourceList
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private ResourceMetaDataTable attributes_;
    private String currentLevel_ = null;
    private int defaultBidiStringType_ = -1;
    private Presentation presentation_;
    private ResourceMetaDataTable selections_;
    private Hashtable selectionValues_ = new Hashtable();
    private ResourceMetaDataTable sorts_;
    private Hashtable sortOrders_ = new Hashtable();
    private Object[] sortValue_ = new Object[0];
    private AS400 system_ = null;
    private transient boolean complete_ = false;
    private transient boolean connectionEstablished_ = false;
    private transient boolean inError_ = false;
    private transient long length_ = -1L;
    private transient boolean open_ = false;
    private transient boolean propertiesFrozen_ = false;
    private transient Vector activeStatusListeners_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient Vector resourceListListeners_;
    private transient VetoableChangeSupport vetoableChangeSupport_;

    public ResourceList() {
        this.presentation_ = new Presentation();
        this.attributes_ = new ResourceMetaDataTable();
        this.selections_ = new ResourceMetaDataTable();
        this.sorts_ = new ResourceMetaDataTable();
        this.initializeTransient();
    }

    public ResourceList(Presentation presentation, ResourceMetaData[] attributeMetaData, ResourceMetaData[] selectionMetaData, ResourceMetaData[] sortMetaData) {
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        this.presentation_ = presentation;
        this.attributes_ = new ResourceMetaDataTable(attributeMetaData);
        this.selections_ = new ResourceMetaDataTable(selectionMetaData);
        this.sorts_ = new ResourceMetaDataTable(sortMetaData);
        this.initializeTransient();
    }

    ResourceList(Presentation presentation, ResourceMetaDataTable attributes, ResourceMetaDataTable selections, ResourceMetaDataTable sorts) {
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        this.presentation_ = presentation;
        this.attributes_ = attributes == null ? new ResourceMetaDataTable() : attributes;
        this.selections_ = selections == null ? new ResourceMetaDataTable() : selections;
        this.sorts_ = sorts == null ? new ResourceMetaDataTable() : sorts;
        this.initializeTransient();
    }

    public void addActiveStatusListener(ActiveStatusListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.activeStatusListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addResourceListListener(ResourceListListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.resourceListListeners_.addElement(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    protected boolean arePropertiesFrozen() {
        return this.propertiesFrozen_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ResourceException {
        if (this.open_) {
            ResourceList resourceList = this;
            synchronized (resourceList) {
                this.complete_ = false;
                this.length_ = -1L;
                this.open_ = false;
                this.inError_ = false;
            }
            this.fireListClosed();
        }
    }

    protected void establishConnection() throws ResourceException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Establishing a connection for " + this + ".");
        }
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (!this.propertiesFrozen_) {
            this.freezeProperties();
        }
        this.connectionEstablished_ = true;
    }

    protected void fireBusy() {
        ActiveStatusEvent event = new ActiveStatusEvent(this, 1);
        Vector temp = (Vector)this.activeStatusListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ActiveStatusListener)list.nextElement()).busy(event);
        }
    }

    protected void fireIdle() {
        ActiveStatusEvent event = new ActiveStatusEvent(this, 2);
        Vector temp = (Vector)this.activeStatusListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ActiveStatusListener)list.nextElement()).idle(event);
        }
    }

    protected void fireLengthChanged(long length) {
        this.length_ = length;
        ResourceListEvent event = new ResourceListEvent(this, 1, length);
        Vector temp = (Vector)this.resourceListListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ResourceListListener)list.nextElement()).lengthChanged(event);
        }
    }

    protected void fireListClosed() {
        ResourceListEvent event = new ResourceListEvent(this, 2);
        Vector temp = (Vector)this.resourceListListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ResourceListListener)list.nextElement()).listClosed(event);
        }
    }

    protected void fireListCompleted() {
        this.complete_ = true;
        ResourceListEvent event = new ResourceListEvent(this, 3);
        Vector temp = (Vector)this.resourceListListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ResourceListListener)list.nextElement()).listCompleted(event);
        }
    }

    protected void fireListInError() {
        this.inError_ = true;
        ResourceListEvent event = new ResourceListEvent(this, 4);
        Vector temp = (Vector)this.resourceListListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ResourceListListener)list.nextElement()).listInError(event);
        }
    }

    protected void fireListOpened() {
        ResourceListEvent event = new ResourceListEvent(this, 5);
        Vector temp = (Vector)this.resourceListListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ResourceListListener)list.nextElement()).listOpened(event);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport_.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void fireResourceAdded(Resource resource, long index) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Resource " + resource + " (index=" + index + ") loaded by list " + this + ".");
        }
        ResourceListEvent event = new ResourceListEvent(this, 6, resource, index);
        Vector temp = (Vector)this.resourceListListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ResourceListListener)list.nextElement()).resourceAdded(event);
        }
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.vetoableChangeSupport_.fireVetoableChange(propertyName, oldValue, newValue);
    }

    protected void freezeProperties() throws ResourceException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Freezing properties for " + this + ".");
        }
        this.propertiesFrozen_ = true;
    }

    public ResourceMetaData getAttributeMetaData(Object attributeID) {
        return this.attributes_.getMetaData(attributeID);
    }

    public ResourceMetaData[] getAttributeMetaData() {
        return this.attributes_.getMetaData(this.getCurrentLevel());
    }

    String getCurrentLevel() {
        if (this.system_ == null) {
            return "";
        }
        if (this.currentLevel_ != null) {
            return this.currentLevel_;
        }
        try {
            this.currentLevel_ = ResourceLevel.vrmToLevel(this.system_.getVRM());
        }
        catch (Exception e) {
            return "";
        }
        return this.currentLevel_;
    }

    int getDefaultBidiStringType() {
        if (this.system_ == null) {
            return 0;
        }
        if (this.defaultBidiStringType_ == -1) {
            this.defaultBidiStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        return this.defaultBidiStringType_;
    }

    public long getListLength() throws ResourceException {
        if (!this.open_) {
            this.open();
        }
        return this.length_;
    }

    public Presentation getPresentation() {
        return this.presentation_;
    }

    public ResourceMetaData getSelectionMetaData(Object selectionID) {
        return this.selections_.getMetaData(selectionID);
    }

    public ResourceMetaData[] getSelectionMetaData() {
        return this.selections_.getMetaData(this.getCurrentLevel());
    }

    public Object getSelectionValue(Object selectionID) throws ResourceException {
        if (this.isBidiEnabled()) {
            return this.getSelectionValue(selectionID, this.getDefaultBidiStringType());
        }
        return this.getSelectionValueImplementation(selectionID);
    }

    public Object getSelectionValue(Object selectionID, int bidiStringType) throws ResourceException {
        if (!this.isBidiEnabled()) {
            return this.getSelectionValue(selectionID);
        }
        return this.getSelectionValueImplementation(selectionID);
    }

    private Object getSelectionValueImplementation(Object selectionID) throws ResourceException {
        this.selections_.validateID(selectionID);
        Object value = this.selectionValues_.get(selectionID);
        if (value == null) {
            value = this.selections_.getMetaData(selectionID).getDefaultValue();
        }
        return value;
    }

    public ResourceMetaData getSortMetaData(Object sortID) {
        return this.sorts_.getMetaData(sortID);
    }

    public ResourceMetaData[] getSortMetaData() {
        return this.sorts_.getMetaData(this.getCurrentLevel());
    }

    public boolean getSortOrder(Object sortID) throws ResourceException {
        this.sorts_.validateID(sortID);
        if (this.sortOrders_.containsKey(sortID)) {
            return (Boolean)this.sortOrders_.get(sortID);
        }
        return true;
    }

    public Object[] getSortValue() throws ResourceException {
        return this.sortValue_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    private void initializeTransient() {
        this.activeStatusListeners_ = new Vector();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.resourceListListeners_ = new Vector();
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
    }

    protected boolean isBidiEnabled() {
        return false;
    }

    public boolean isComplete() {
        return this.complete_;
    }

    protected boolean isConnectionEstablished() {
        return this.connectionEstablished_;
    }

    public boolean isInError() {
        return this.inError_;
    }

    public boolean isOpen() {
        return this.open_;
    }

    public boolean isResourceAvailable(long index) throws ResourceException {
        if (index < 0L) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return index < this.length_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceException {
        if (this.open_) {
            return;
        }
        ResourceList resourceList = this;
        synchronized (resourceList) {
            this.complete_ = false;
            this.inError_ = false;
            this.open_ = true;
            this.length_ = 0L;
            if (Trace.isTraceOn()) {
                Trace.log(3, "Opening list " + this + ".");
            }
            this.fireListOpened();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshContents() throws ResourceException {
        ResourceList resourceList = this;
        synchronized (resourceList) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "Refreshing list contents for " + this + ".");
            }
            if (!this.open_) {
                this.open();
            }
        }
    }

    public void refreshStatus() throws ResourceException {
        if (!this.open_) {
            this.open();
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "Refreshing status for list " + this + ".");
        }
    }

    public void removeActiveStatusListener(ActiveStatusListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.activeStatusListeners_.removeElement(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeResourceListListener(ResourceListListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.resourceListListeners_.removeElement(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public Resource resourceAt(long index) throws ResourceException {
        if (!this.open_) {
            this.open();
        }
        if (index < 0L || this.complete_ && index >= this.length_) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return null;
    }

    public Enumeration resources() throws ResourceException {
        return new ResourceListEnumeration(this);
    }

    protected void setAttributeMetaData(ResourceMetaData[] attributeMetaData) {
        if (attributeMetaData == null) {
            throw new NullPointerException("attributeMetaData");
        }
        this.attributes_ = new ResourceMetaDataTable(attributeMetaData);
    }

    public void setSelectionValue(Object selectionID, Object value) throws ResourceException {
        if (this.isBidiEnabled()) {
            this.setSelectionValue(selectionID, value, this.getDefaultBidiStringType());
        } else {
            this.setSelectionValueImplementation(selectionID, value);
        }
    }

    public void setSelectionValue(Object selectionID, Object value, int bidiStringType) throws ResourceException {
        if (!this.isBidiEnabled()) {
            this.setSelectionValue(selectionID, value);
        } else {
            this.setSelectionValueImplementation(selectionID, value);
        }
    }

    private void setSelectionValueImplementation(Object selectionID, Object value) throws ResourceException {
        ResourceMetaData selectionMetaData = this.selections_.validateID(selectionID);
        if (value == null) {
            this.selectionValues_.remove(selectionID);
        } else {
            this.selectionValues_.put(selectionID, selectionMetaData.validateValue(value));
        }
    }

    protected void setPresentation(Presentation presentation) {
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        this.presentation_ = presentation;
    }

    public void setSortOrder(Object sortID, boolean sortOrder) throws ResourceException {
        this.sorts_.validateID(sortID);
        this.sortOrders_.put(sortID, sortOrder ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setSortValue(Object[] sortValue) throws ResourceException {
        if (sortValue == null) {
            throw new NullPointerException("sortValue");
        }
        this.sorts_.validateIDs(sortValue);
        this.sortValue_ = sortValue;
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        AS400 oldValue = this.system_;
        this.fireVetoableChange("system", oldValue, system);
        this.system_ = system;
        this.firePropertyChange("system", oldValue, system);
    }

    public String toString() {
        if (this.presentation_ == null) {
            return super.toString();
        }
        String fullName = this.presentation_.getFullName();
        if (fullName.length() > 0) {
            return fullName;
        }
        return super.toString();
    }

    public void waitForComplete() throws ResourceException {
        if (!this.open_) {
            this.open();
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "Waiting for the list to complete.");
        }
    }

    public void waitForResource(long index) throws ResourceException {
        if (index < 0L) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        if (!this.open_) {
            this.open();
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "Waiting for resource " + index + " to become available.");
        }
    }
}

