/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.vaccess.ResourceLoader;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class ResourceProperties
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String RESOURCE_GENERAL_TAB_ = ResourceLoader.getText("RESOURCE_GENERAL_TAB");
    private static final Object FIRST_TAB_KEY_ = 0;
    private boolean editable_ = false;
    private int tabCounter_ = 0;
    private Hashtable tabPropertyIDs_ = new Hashtable();
    private Hashtable tabLabels_ = new Hashtable();

    public ResourceProperties() {
        this(new Object[0], RESOURCE_GENERAL_TAB_, true);
    }

    public ResourceProperties(String firstTabLabel, boolean editable) {
        this(new Object[0], firstTabLabel, editable);
    }

    public ResourceProperties(Object[] propertyIDs, String firstTabLabel, boolean editable) {
        if (propertyIDs == null) {
            throw new NullPointerException("propertyIDs");
        }
        if (firstTabLabel == null) {
            throw new NullPointerException("firstTabLabel");
        }
        Vector<Object> v = new Vector<Object>(propertyIDs.length);
        for (int i = 0; i < propertyIDs.length; ++i) {
            if (propertyIDs[i] == null) {
                throw new NullPointerException("propertyIDs[" + i + "]");
            }
            v.addElement(propertyIDs[i]);
        }
        this.tabPropertyIDs_.put(FIRST_TAB_KEY_, v);
        this.tabLabels_.put(FIRST_TAB_KEY_, firstTabLabel);
        this.editable_ = editable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(Object propertyID) {
        if (propertyID == null) {
            throw new NullPointerException("propertyID");
        }
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            ((Vector)this.tabPropertyIDs_.get(FIRST_TAB_KEY_)).addElement(propertyID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(int tab, Object propertyID) {
        if (propertyID == null) {
            throw new NullPointerException("propertyID");
        }
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            Integer key = tab;
            if (!this.tabPropertyIDs_.containsKey(key)) {
                throw new ExtendedIllegalArgumentException("tab", 2);
            }
            ((Vector)this.tabPropertyIDs_.get(key)).addElement(propertyID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(Object[] propertyIDs) {
        if (propertyIDs == null) {
            throw new NullPointerException("propertyIDs");
        }
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            Vector v = (Vector)this.tabPropertyIDs_.get(FIRST_TAB_KEY_);
            for (int i = 0; i < propertyIDs.length; ++i) {
                if (propertyIDs[i] == null) {
                    throw new NullPointerException("propertyIDs[" + i + "]");
                }
                v.addElement(propertyIDs[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(int tab, Object[] propertyIDs) {
        if (propertyIDs == null) {
            throw new NullPointerException("propertyIDs");
        }
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            Integer key = tab;
            if (!this.tabPropertyIDs_.containsKey(key)) {
                throw new ExtendedIllegalArgumentException("tab", 2);
            }
            Vector v = (Vector)this.tabPropertyIDs_.get(key);
            for (int i = 0; i < propertyIDs.length; ++i) {
                if (propertyIDs[i] == null) {
                    throw new NullPointerException("propertyIDs[" + i + "]");
                }
                v.addElement(propertyIDs[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTab(String label) {
        if (label == null) {
            throw new NullPointerException("label");
        }
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            ++this.tabCounter_;
            Integer key = this.tabCounter_;
            this.tabPropertyIDs_.put(key, new Vector());
            this.tabLabels_.put(key, label);
            return this.tabCounter_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTab(String label, Object[] propertyIDs) {
        if (label == null) {
            throw new NullPointerException("label");
        }
        if (propertyIDs == null) {
            throw new NullPointerException("propertyIDs");
        }
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            Vector<Object> v = new Vector<Object>(propertyIDs.length);
            for (int i = 0; i < propertyIDs.length; ++i) {
                if (propertyIDs[i] == null) {
                    throw new NullPointerException("propertyIDs[" + i + "]");
                }
                v.addElement(propertyIDs[i]);
            }
            ++this.tabCounter_;
            Integer key = this.tabCounter_;
            this.tabPropertyIDs_.put(key, v);
            this.tabLabels_.put(key, label);
            return this.tabCounter_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabel(int tab) {
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            Integer key = tab;
            if (!this.tabLabels_.containsKey(key)) {
                throw new ExtendedIllegalArgumentException("tab", 2);
            }
            return (String)this.tabLabels_.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getProperties(int tab) {
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            Integer key = tab;
            if (!this.tabPropertyIDs_.containsKey(key)) {
                throw new ExtendedIllegalArgumentException("tab", 2);
            }
            Vector asVector = (Vector)this.tabPropertyIDs_.get(key);
            Object[] propertyIDs = new Object[asVector.size()];
            asVector.copyInto(propertyIDs);
            return propertyIDs;
        }
    }

    public int getTabCount() {
        return this.tabCounter_ + 1;
    }

    public boolean isEditable() {
        return this.editable_;
    }

    public void setEditable(boolean editable) {
        this.editable_ = editable;
    }
}

