/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.VObject;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.Collator;
import java.util.Date;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

class VUtilities {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static Collator collator_;

    VUtilities() {
    }

    public static void constrain(Component component, JPanel panel, GridBagLayout layout, GridBagConstraints constraints, int gridx, int gridwidth, int weightx, int gridy, int gridheight, int weighty, int fill, int anchor) {
        panel.add(component);
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = gridwidth;
        constraints.gridheight = gridheight;
        constraints.fill = fill;
        constraints.anchor = anchor;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        layout.setConstraints(component, constraints);
    }

    public static void constrain(Component component, JPanel panel, GridBagLayout layout, int gridx, int gridy, int gridwidth, int gridheight) {
        panel.add(component);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = gridwidth;
        constraints.gridheight = gridheight;
        constraints.fill = 1;
        constraints.ipady = 2;
        constraints.insets = new Insets(2, 0, 2, 0);
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        layout.setConstraints(component, constraints);
    }

    public static void constrain(Component component, Component component2, JPanel panel, GridBagLayout layout, int gridy) {
        VUtilities.constrain(component, panel, layout, 0, gridy, 1, 1);
        VUtilities.constrain(component2, panel, layout, 1, gridy, 1, 1);
    }

    public static void constrain(String string1, String string2, JPanel panel, GridBagLayout layout, int gridy) {
        VUtilities.constrain(new JLabel(string1), new JLabel(string2), panel, layout, gridy);
    }

    public static void constrain(Component component, JPanel panel, GridBagLayout layout, int gridy) {
        VUtilities.constrain(component, panel, layout, 0, gridy, 2, 1);
    }

    public static String formatHelp(String helpText, int width) {
        StringBuffer newHelp = new StringBuffer();
        int len = helpText.length();
        int j = 0;
        int i = 0;
        while (i < len) {
            if (j == width) {
                newHelp.append("\n");
                j = 0;
            }
            if (helpText.charAt(i) == '&') {
                newHelp.append("\n");
                j = 0;
                ++i;
            } else {
                newHelp = newHelp.append(helpText.charAt(i));
            }
            ++i;
            ++j;
        }
        return newHelp.toString();
    }

    public static String formatHelp2(String input, int width) {
        StringBuffer output = new StringBuffer(input);
        int lowEnd = 0;
        int highEnd = width;
        while (highEnd < output.length()) {
            int i;
            for (i = highEnd; i > lowEnd; --i) {
                if (output.charAt(i) != ' ') continue;
                output.setCharAt(i, '\n');
                break;
            }
            if (i == lowEnd) {
                output = output.insert(highEnd, '\n');
                lowEnd = highEnd;
                highEnd += width;
                continue;
            }
            highEnd = i + width;
            lowEnd = i;
        }
        return output.toString();
    }

    public static String getExceptionText(Exception e) {
        String text = e.getMessage();
        if (text == null) {
            text = e.getClass().toString();
        } else if (text.length() == 0) {
            text = e.getClass().toString();
        }
        return text;
    }

    public static Frame getFrame(Component component) {
        Component c = component;
        while (c != null && !(c instanceof Frame)) {
            c = VUtilities.getParentComponent(c);
        }
        return (Frame)c;
    }

    private static Component getParentComponent(Component component) {
        Component parent = component instanceof JPopupMenu ? ((JPopupMenu)component).getInvoker() : component.getParent();
        return parent;
    }

    public static void sort(VObject[] objects, Object[] propertyIdentifiers, boolean[] orders) {
        boolean[] orders2;
        if (propertyIdentifiers.length > orders.length) {
            orders2 = new boolean[propertyIdentifiers.length];
            System.arraycopy(orders, 0, orders2, 0, orders.length);
        } else {
            orders2 = orders;
        }
        if (Trace.isTraceOn()) {
            StringBuffer b1 = new StringBuffer();
            for (int i = 0; i < propertyIdentifiers.length; ++i) {
                b1.append(propertyIdentifiers[i]);
                b1.append(" (");
                b1.append(orders2[i] ? "ascending" : "descending");
                b1.append(")");
                if (i == propertyIdentifiers.length - 1) continue;
                b1.append(", ");
            }
            Trace.log(3, "Sorting by " + b1 + ".");
        }
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            for (int j = i + 1; j < length; ++j) {
                if (!VUtilities.sortCompare(objects[i], objects[j], propertyIdentifiers, orders)) continue;
                VObject temp = objects[i];
                objects[i] = objects[j];
                objects[j] = temp;
            }
        }
    }

    public static void sort(Vector objects, Object[] propertyIdentifiers, boolean[] orders) {
        Object[] objectArray = new VObject[objects.size()];
        objects.copyInto(objectArray);
        VUtilities.sort((VObject[])objectArray, propertyIdentifiers, orders);
        objects.removeAllElements();
        for (int i = 0; i < objectArray.length; ++i) {
            objects.addElement(objectArray[i]);
        }
    }

    private static boolean sortCompare(VObject objectI, VObject objectJ, Object[] propertyIdentifiers, boolean[] orders) {
        for (int i = 0; i < propertyIdentifiers.length; ++i) {
            boolean comparison;
            Object valueJ;
            Object valueI;
            if (propertyIdentifiers[i] != null) {
                valueI = objectI.getPropertyValue(propertyIdentifiers[i]);
                valueJ = objectJ.getPropertyValue(propertyIdentifiers[i]);
            } else {
                valueI = objectI.toString();
                valueJ = objectJ.toString();
            }
            if (valueI == null) {
                valueI = "";
            }
            if (valueJ == null) {
                valueJ = "";
            }
            if (valueI instanceof Date) {
                comparison = ((Date)valueI).after((Date)valueJ);
            } else {
                if (valueI.toString().equals(valueJ.toString())) continue;
                if (valueI instanceof Number || valueJ instanceof Number) {
                    long li = valueI instanceof Number ? ((Number)valueI).longValue() : -1L;
                    long lj = valueJ instanceof Number ? ((Number)valueJ).longValue() : -1L;
                    comparison = li < lj;
                } else {
                    comparison = collator_ != null ? collator_.compare(valueI.toString(), valueJ.toString()) < 0 : valueI.toString().compareTo(valueJ.toString()) < 0;
                }
            }
            return comparison != orders[i];
        }
        return true;
    }

    static {
        try {
            collator_ = Collator.getInstance();
            collator_.setStrength(0);
        }
        catch (Exception e) {
            collator_ = null;
        }
    }
}

