/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import java.io.Serializable;
import java.util.Optional;
import java.util.stream.LongStream;
import org.apache.beam.sdk.io.synthetic.SyntheticSourceOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.base.AbstractInstant;

class SyntheticWatermark
implements Serializable {
    private @UnknownKeyFor @NonNull @Initialized SyntheticSourceOptions options;
    private final @UnknownKeyFor @NonNull @Initialized long endOffset;
    private @UnknownKeyFor @NonNull @Initialized Instant watermark;

    SyntheticWatermark(@UnknownKeyFor @NonNull @Initialized SyntheticSourceOptions options, @UnknownKeyFor @NonNull @Initialized long endOffset) {
        this.options = options;
        this.endOffset = endOffset;
        this.watermark = new Instant(0L);
    }

    @UnknownKeyFor @NonNull @Initialized Instant calculateNew(@UnknownKeyFor @NonNull @Initialized long currentOffset, @UnknownKeyFor @NonNull @Initialized Instant processingTime) {
        if (currentOffset >= this.endOffset) {
            this.watermark = BoundedWindow.TIMESTAMP_MAX_VALUE;
            return this.watermark;
        }
        Instant newWatermark = this.findLowestEventTimeInAdvance(currentOffset, processingTime).minus((ReadableDuration)Duration.millis((long)this.options.watermarkDriftMillis.intValue()));
        if (newWatermark.getMillis() > this.watermark.getMillis()) {
            this.watermark = newWatermark;
        }
        return this.watermark;
    }

    private @UnknownKeyFor @NonNull @Initialized Instant findLowestEventTimeInAdvance(@UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized Instant processingTime) {
        Optional<Instant> minEventTime = LongStream.range(offset, offset + (long)this.options.watermarkSearchInAdvanceCount.intValue()).mapToObj(element -> this.eventTime(element, processingTime)).min(AbstractInstant::compareTo);
        return minEventTime.orElse(this.eventTime(offset, processingTime));
    }

    private @UnknownKeyFor @NonNull @Initialized Instant eventTime(@UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized Instant processingTime) {
        return processingTime.minus((ReadableDuration)this.options.nextProcessingTimeDelay(offset));
    }
}

