/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Stream;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileMonitor;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractFileSystem;

public class DefaultFileMonitor
implements Runnable,
FileMonitor,
AutoCloseable {
    private static final ThreadFactory THREAD_FACTORY = new BasicThreadFactory.Builder().daemon(true).priority(1).build();
    private static final Log LOG = LogFactory.getLog(DefaultFileMonitor.class);
    private static final Duration DEFAULT_DELAY = Duration.ofSeconds(1L);
    private static final int DEFAULT_MAX_FILES = 1000;
    private final Map<FileName, FileMonitorAgent> monitorMap = new HashMap<FileName, FileMonitorAgent>();
    private Thread monitorThread;
    private final Stack<FileObject> deleteStack = new Stack();
    private final Stack<FileObject> addStack = new Stack();
    private volatile boolean runFlag = true;
    private boolean recursive;
    private Duration delay = DEFAULT_DELAY;
    private int checksPerRun = 1000;
    private final FileListener listener;

    public DefaultFileMonitor(FileListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(FileObject file) {
        Map<FileName, FileMonitorAgent> map = this.monitorMap;
        synchronized (map) {
            if (this.monitorMap.get(file.getName()) == null) {
                this.monitorMap.put(file.getName(), new FileMonitorAgent(this, file));
                try {
                    if (this.listener != null) {
                        file.getFileSystem().addListener(file, this.listener);
                    }
                    if (file.getType().hasChildren() && this.recursive) {
                        Stream.of(file.getChildren()).forEach(this::addFile);
                    }
                }
                catch (FileSystemException fse) {
                    LOG.error((Object)fse.getLocalizedMessage(), (Throwable)fse);
                }
            }
        }
    }

    @Override
    public void close() {
        this.runFlag = false;
        if (this.monitorThread != null) {
            this.monitorThread.interrupt();
            try {
                this.monitorThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.monitorThread = null;
        }
    }

    public int getChecksPerRun() {
        return this.checksPerRun;
    }

    @Deprecated
    public long getDelay() {
        return this.delay.toMillis();
    }

    public Duration getDelayDuration() {
        return this.delay;
    }

    FileListener getFileListener() {
        return this.listener;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    protected void queueAddFile(FileObject file) {
        this.addStack.push(file);
    }

    protected void queueRemoveFile(FileObject file) {
        this.deleteStack.push(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFile(FileObject file) {
        Map<FileName, FileMonitorAgent> map = this.monitorMap;
        synchronized (map) {
            FileName fn = file.getName();
            if (this.monitorMap.get(fn) != null) {
                FileMonitorAgent parentAgent;
                FileObject parent;
                try {
                    parent = file.getParent();
                }
                catch (FileSystemException fse) {
                    parent = null;
                }
                this.monitorMap.remove(fn);
                if (parent != null && (parentAgent = this.monitorMap.get(parent.getName())) != null) {
                    parentAgent.resetChildrenList();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: while (!this.monitorThread.isInterrupted() && this.runFlag) {
            Object[] fileNames;
            Map<FileName, FileMonitorAgent> map = this.monitorMap;
            synchronized (map) {
                fileNames = this.monitorMap.keySet().toArray();
            }
            for (int iterFileNames = 0; iterFileNames < fileNames.length; ++iterFileNames) {
                FileMonitorAgent agent;
                FileName fileName = (FileName)fileNames[iterFileNames];
                Map<FileName, FileMonitorAgent> map2 = this.monitorMap;
                synchronized (map2) {
                    agent = this.monitorMap.get(fileName);
                }
                if (agent != null) {
                    agent.check();
                }
                if (this.getChecksPerRun() > 0 && (iterFileNames + 1) % this.getChecksPerRun() == 0) {
                    try {
                        Thread.sleep(this.getDelayDuration().toMillis());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.monitorThread.isInterrupted() || !this.runFlag) continue block10;
            }
            while (!this.addStack.empty()) {
                this.addFile(this.addStack.pop());
            }
            while (!this.deleteStack.empty()) {
                this.removeFile(this.deleteStack.pop());
            }
            try {
                Thread.sleep(this.getDelayDuration().toMillis());
            }
            catch (InterruptedException e) {}
        }
        this.runFlag = true;
    }

    public void setChecksPerRun(int checksPerRun) {
        this.checksPerRun = checksPerRun;
    }

    public void setDelay(Duration delay) {
        this.delay = delay == null || delay.isNegative() ? DEFAULT_DELAY : delay;
    }

    @Deprecated
    public void setDelay(long delay) {
        this.setDelay(delay > 0L ? Duration.ofMillis(delay) : DEFAULT_DELAY);
    }

    public void setRecursive(boolean newRecursive) {
        this.recursive = newRecursive;
    }

    public synchronized void start() {
        if (this.monitorThread == null) {
            this.monitorThread = THREAD_FACTORY.newThread(this);
        }
        this.monitorThread.start();
    }

    public synchronized void stop() {
        this.close();
    }

    private static final class FileMonitorAgent {
        private final FileObject fileObject;
        private final DefaultFileMonitor defaultFileMonitor;
        private boolean exists;
        private long timestamp;
        private Map<FileName, Object> children;

        private FileMonitorAgent(DefaultFileMonitor defaultFileMonitor, FileObject fileObject) {
            this.defaultFileMonitor = defaultFileMonitor;
            this.fileObject = fileObject;
            this.refresh();
            this.resetChildrenList();
            try {
                this.exists = fileObject.exists();
            }
            catch (FileSystemException fse) {
                this.exists = false;
                this.timestamp = -1L;
            }
            if (this.exists) {
                try {
                    this.timestamp = fileObject.getContent().getLastModifiedTime();
                }
                catch (FileSystemException fse) {
                    this.timestamp = -1L;
                }
            }
        }

        private void check() {
            this.refresh();
            try {
                if (this.exists && !this.fileObject.exists()) {
                    this.exists = this.fileObject.exists();
                    this.timestamp = -1L;
                    ((AbstractFileSystem)this.fileObject.getFileSystem()).fireFileDeleted(this.fileObject);
                    if (this.defaultFileMonitor.getFileListener() != null) {
                        this.fileObject.getFileSystem().removeListener(this.fileObject, this.defaultFileMonitor.getFileListener());
                    }
                    this.defaultFileMonitor.queueRemoveFile(this.fileObject);
                } else if (this.exists && this.fileObject.exists()) {
                    if (this.timestamp != this.fileObject.getContent().getLastModifiedTime()) {
                        this.timestamp = this.fileObject.getContent().getLastModifiedTime();
                        if (!this.fileObject.getType().hasChildren()) {
                            ((AbstractFileSystem)this.fileObject.getFileSystem()).fireFileChanged(this.fileObject);
                        }
                    }
                } else if (!this.exists && this.fileObject.exists()) {
                    this.exists = this.fileObject.exists();
                    this.timestamp = this.fileObject.getContent().getLastModifiedTime();
                    if (!this.fileObject.getType().hasChildren()) {
                        ((AbstractFileSystem)this.fileObject.getFileSystem()).fireFileCreated(this.fileObject);
                    }
                }
                this.checkForNewChildren();
            }
            catch (FileSystemException fse) {
                LOG.error((Object)fse.getLocalizedMessage(), (Throwable)fse);
            }
        }

        private void checkForNewChildren() {
            try {
                if (this.fileObject.getType().hasChildren()) {
                    FileObject[] newChildren = this.fileObject.getChildren();
                    if (this.children != null) {
                        HashMap<FileName, Object> newChildrenMap = new HashMap<FileName, Object>();
                        Stack<FileObject> missingChildren = new Stack<FileObject>();
                        for (FileObject element : newChildren) {
                            newChildrenMap.put(element.getName(), new Object());
                            if (this.children.containsKey(element.getName())) continue;
                            missingChildren.push(element);
                        }
                        this.children = newChildrenMap;
                        if (!missingChildren.empty()) {
                            while (!missingChildren.empty()) {
                                this.fireAllCreate((FileObject)missingChildren.pop());
                            }
                        }
                    } else if (newChildren.length > 0) {
                        this.children = new HashMap<FileName, Object>();
                        for (FileObject element : newChildren) {
                            this.children.put(element.getName(), new Object());
                            this.fireAllCreate(element);
                        }
                    }
                }
            }
            catch (FileSystemException fse) {
                LOG.error((Object)fse.getLocalizedMessage(), (Throwable)fse);
            }
        }

        private void fireAllCreate(FileObject child) {
            if (this.defaultFileMonitor.getFileListener() != null) {
                child.getFileSystem().addListener(child, this.defaultFileMonitor.getFileListener());
            }
            ((AbstractFileSystem)child.getFileSystem()).fireFileCreated(child);
            if (this.defaultFileMonitor.getFileListener() != null) {
                child.getFileSystem().removeListener(child, this.defaultFileMonitor.getFileListener());
            }
            this.defaultFileMonitor.queueAddFile(child);
            try {
                if (this.defaultFileMonitor.isRecursive() && child.getType().hasChildren()) {
                    Stream.of(child.getChildren()).forEach(this::fireAllCreate);
                }
            }
            catch (FileSystemException fse) {
                LOG.error((Object)fse.getLocalizedMessage(), (Throwable)fse);
            }
        }

        private void refresh() {
            try {
                this.fileObject.refresh();
            }
            catch (FileSystemException fse) {
                LOG.error((Object)fse.getLocalizedMessage(), (Throwable)fse);
            }
        }

        private void resetChildrenList() {
            try {
                if (this.fileObject.getType().hasChildren()) {
                    this.children = new HashMap<FileName, Object>();
                    for (FileObject element : this.fileObject.getChildren()) {
                        this.children.put(element.getName(), new Object());
                    }
                }
            }
            catch (FileSystemException fse) {
                this.children = null;
            }
        }
    }
}

