/*
 * Decompiled with CFR 0.152.
 */
package io.crate.client.jdbc;

public class CrateDriverVersion {
    private static final boolean SNAPSHOT = false;
    static final CrateDriverVersion CURRENT = new CrateDriverVersion(20700, false);
    private final int id;
    final byte major;
    final byte minor;
    private final byte revision;
    private final Boolean snapshot;

    private CrateDriverVersion(int id, Boolean snapshot) {
        this.id = id;
        this.major = (byte)(id / 10000 % 100);
        this.minor = (byte)(id / 100 % 100);
        this.revision = (byte)(id % 100);
        this.snapshot = snapshot;
    }

    private boolean snapshot() {
        return this.snapshot != null && this.snapshot != false;
    }

    private String number() {
        return String.valueOf(this.major) + '.' + this.minor + '.' + this.revision;
    }

    public static void main(String[] args) {
        System.out.println("Version: " + CURRENT + ", JVM: " + System.getProperty("java.version"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.number());
        if (this.snapshot()) {
            sb.append("-SNAPSHOT");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrateDriverVersion version = (CrateDriverVersion)o;
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }
}

