/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.concurrent.TaskFactory;
import org.apache.cassandra.concurrent.ThreadPoolExecutorBase;
import org.apache.cassandra.concurrent.ThreadPoolExecutorBuilder;
import org.apache.cassandra.utils.WithResources;
import org.apache.cassandra.utils.concurrent.Future;

public class ThreadPoolExecutorPlus
extends ThreadPoolExecutorBase
implements ExecutorPlus {
    final TaskFactory taskFactory;

    ThreadPoolExecutorPlus(ThreadPoolExecutorBuilder<? extends ThreadPoolExecutorPlus> builder) {
        this(builder, TaskFactory.standard());
    }

    ThreadPoolExecutorPlus(ThreadPoolExecutorBuilder<? extends ThreadPoolExecutorPlus> builder, TaskFactory taskFactory) {
        super(builder);
        this.taskFactory = taskFactory;
    }

    private <T extends Runnable> T addTask(T task) {
        super.execute(task);
        return task;
    }

    @Override
    public void execute(Runnable run) {
        this.addTask(this.taskFactory.toExecute(run));
    }

    @Override
    public void execute(WithResources withResources, Runnable run) {
        this.addTask(this.taskFactory.toExecute(withResources, run));
    }

    @Override
    public Future<?> submit(Runnable run) {
        return this.addTask(this.taskFactory.toSubmit(run));
    }

    @Override
    public <T> Future<T> submit(Runnable run, T result) {
        return this.addTask(this.taskFactory.toSubmit(run, result));
    }

    @Override
    public <T> Future<T> submit(Callable<T> call) {
        return this.addTask(this.taskFactory.toSubmit(call));
    }

    @Override
    public <T> Future<T> submit(WithResources withResources, Runnable run, T result) {
        return this.addTask(this.taskFactory.toSubmit(withResources, run, result));
    }

    @Override
    public Future<?> submit(WithResources withResources, Runnable run) {
        return this.addTask(this.taskFactory.toSubmit(withResources, run));
    }

    @Override
    public <T> Future<T> submit(WithResources withResources, Callable<T> call) {
        return this.addTask(this.taskFactory.toSubmit(withResources, call));
    }

    @Override
    public boolean inExecutor() {
        return Thread.currentThread().getThreadGroup() == this.getThreadFactory().threadGroup;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return this.taskFactory.toSubmit(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return this.taskFactory.toSubmit(callable);
    }

    @Override
    public int getMaxTasksQueued() {
        return this.getQueue().size();
    }
}

