/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.netty.util.concurrent.Future;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.InternodeOutboundMetrics;
import org.apache.cassandra.net.ConnectionType;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.OutboundConnection;
import org.apache.cassandra.net.OutboundConnectionSettings;
import org.apache.cassandra.net.ResourceLimits;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.concurrent.Condition;
import org.apache.cassandra.utils.concurrent.FutureCombiner;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundConnections {
    private static final Logger logger = LoggerFactory.getLogger(OutboundConnections.class);
    @VisibleForTesting
    public static final int LARGE_MESSAGE_THRESHOLD = Integer.getInteger("cassandra.otcp_large_message_threshold", 65536) - Math.max(Math.max(21, 10), 12);
    private final Condition metricsReady = Condition.newOneTimeCondition();
    private volatile InternodeOutboundMetrics metrics;
    private final ResourceLimits.Limit reserveCapacity;
    private OutboundConnectionSettings template;
    public final OutboundConnection small;
    public final OutboundConnection large;
    public final OutboundConnection urgent;

    private OutboundConnections(OutboundConnectionSettings template) {
        this.template = template = template.withDefaultReserveLimits();
        this.reserveCapacity = new ResourceLimits.Concurrent(template.applicationSendQueueReserveEndpointCapacityInBytes.intValue());
        ResourceLimits.EndpointAndGlobal reserveCapacityInBytes = new ResourceLimits.EndpointAndGlobal(this.reserveCapacity, template.applicationSendQueueReserveGlobalCapacityInBytes);
        this.small = new OutboundConnection(ConnectionType.SMALL_MESSAGES, template, reserveCapacityInBytes);
        this.large = new OutboundConnection(ConnectionType.LARGE_MESSAGES, template, reserveCapacityInBytes);
        this.urgent = new OutboundConnection(ConnectionType.URGENT_MESSAGES, template, reserveCapacityInBytes);
    }

    public void enqueue(Message msg, ConnectionType type) throws ClosedChannelException {
        this.connectionFor(msg, type).enqueue(msg);
    }

    static <K> OutboundConnections tryRegister(ConcurrentMap<K, OutboundConnections> in, K key, OutboundConnectionSettings settings) {
        OutboundConnections connections = (OutboundConnections)in.get(key);
        if (connections == null) {
            connections = new OutboundConnections(settings);
            OutboundConnections existing = in.putIfAbsent(key, connections);
            if (existing == null) {
                connections.metrics = new InternodeOutboundMetrics(settings.to, connections);
                connections.metricsReady.signalAll();
            } else {
                connections.metricsReady.signalAll();
                connections.close(false);
                connections = existing;
            }
        }
        return connections;
    }

    synchronized Future<Void> reconnectWithNewIp(InetAddressAndPort addr) {
        this.template = this.template.withConnectTo(addr);
        return FutureCombiner.nettySuccessListener(this.apply(c -> c.reconnectWith(this.template)));
    }

    synchronized Future<Void> scheduleClose(long time, TimeUnit unit, boolean flushQueues) {
        this.releaseMetrics();
        return FutureCombiner.nettySuccessListener(this.apply(c -> c.scheduleClose(time, unit, flushQueues)));
    }

    synchronized Future<Void> close(boolean flushQueues) {
        this.releaseMetrics();
        return FutureCombiner.nettySuccessListener(this.apply(c -> c.close(flushQueues)));
    }

    private void releaseMetrics() {
        try {
            this.metricsReady.await();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        if (this.metrics != null) {
            this.metrics.release();
        }
    }

    void interrupt() {
        this.apply(OutboundConnection::interrupt);
    }

    private <V> List<V> apply(Function<OutboundConnection, V> f) {
        return ImmutableList.of(f.apply(this.urgent), f.apply(this.small), f.apply(this.large));
    }

    @VisibleForTesting
    OutboundConnection connectionFor(Message<?> message) {
        return this.connectionFor(message, null);
    }

    private OutboundConnection connectionFor(Message msg, ConnectionType forceConnection) {
        return this.connectionFor(OutboundConnections.connectionTypeFor(msg, forceConnection));
    }

    private static ConnectionType connectionTypeFor(Message<?> msg, ConnectionType specifyConnection) {
        if (specifyConnection != null) {
            return specifyConnection;
        }
        if (msg.serializedSize(12) > LARGE_MESSAGE_THRESHOLD) {
            if (msg.verb().priority == Verb.Priority.P0) {
                NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, "Enqueued URGENT message which exceeds large message threshold", new Object[0]);
                if (logger.isTraceEnabled()) {
                    logger.trace("{} message with size {} exceeded large message threshold {}", new Object[]{msg.verb(), msg.serializedSize(12), LARGE_MESSAGE_THRESHOLD});
                }
            }
            return ConnectionType.LARGE_MESSAGES;
        }
        return msg.verb().priority == Verb.Priority.P0 ? ConnectionType.URGENT_MESSAGES : ConnectionType.SMALL_MESSAGES;
    }

    @VisibleForTesting
    final OutboundConnection connectionFor(ConnectionType type) {
        switch (type) {
            case SMALL_MESSAGES: {
                return this.small;
            }
            case LARGE_MESSAGES: {
                return this.large;
            }
            case URGENT_MESSAGES: {
                return this.urgent;
            }
        }
        throw new IllegalArgumentException("unsupported connection type: " + (Object)((Object)type));
    }

    public long usingReserveBytes() {
        return this.reserveCapacity.using();
    }

    long expiredCallbacks() {
        return this.metrics.expiredCallbacks.getCount();
    }

    void incrementExpiredCallbackCount() {
        this.metrics.expiredCallbacks.mark();
    }

    OutboundConnectionSettings template() {
        return this.template;
    }

    static void scheduleUnusedConnectionMonitoring(MessagingService messagingService, ScheduledExecutorService executor, long delay, TimeUnit units) {
        executor.scheduleWithFixedDelay(() -> OutboundConnections.lambda$scheduleUnusedConnectionMonitoring$3(new UnusedConnectionMonitor(messagingService)), 0L, delay, units);
    }

    @VisibleForTesting
    static OutboundConnections unsafeCreate(OutboundConnectionSettings template) {
        OutboundConnections connections = new OutboundConnections(template);
        connections.metricsReady.signalAll();
        return connections;
    }

    private static /* synthetic */ void lambda$scheduleUnusedConnectionMonitoring$3(UnusedConnectionMonitor rec$) {
        rec$.closeUnusedSinceLastRun();
    }

    private static class UnusedConnectionMonitor {
        final MessagingService messagingService;
        ObjectObjectHashMap<InetAddressAndPort, Counts> prevEndpointToCounts = new ObjectObjectHashMap();

        UnusedConnectionMonitor(MessagingService messagingService) {
            this.messagingService = messagingService;
        }

        private void closeUnusedSinceLastRun() {
            ObjectObjectHashMap curEndpointToCounts = new ObjectObjectHashMap();
            for (OutboundConnections connections : this.messagingService.channelManagers.values()) {
                Counts cur = new Counts(connections.small.submittedCount(), connections.large.submittedCount(), connections.urgent.submittedCount());
                curEndpointToCounts.put((Object)((OutboundConnections)connections).template.to, (Object)cur);
                Counts prev = (Counts)this.prevEndpointToCounts.get((Object)((OutboundConnections)connections).template.to);
                if (prev == null || cur.small != prev.small && cur.large != prev.large && cur.urgent != prev.urgent) continue;
                if (cur.small == prev.small && cur.large == prev.large && cur.urgent == prev.urgent && !Gossiper.instance.isKnownEndpoint(((OutboundConnections)connections).template.to)) {
                    logger.info("Closing outbound connections to {}, as inactive and not known by Gossiper", (Object)((OutboundConnections)connections).template.to);
                    this.messagingService.closeOutboundNow(connections);
                    continue;
                }
                if (cur.small == prev.small) {
                    connections.small.interrupt();
                }
                if (cur.large == prev.large) {
                    connections.large.interrupt();
                }
                if (cur.urgent != prev.urgent) continue;
                connections.urgent.interrupt();
            }
            this.prevEndpointToCounts = curEndpointToCounts;
        }

        static class Counts {
            final long small;
            final long large;
            final long urgent;

            Counts(long small, long large, long urgent) {
                this.small = small;
                this.large = large;
                this.urgent = urgent;
            }
        }
    }
}

