/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.impl.prefetch.BlockData;
import org.apache.hadoop.fs.impl.prefetch.ExecutorServiceFuturePool;
import org.apache.hadoop.fs.impl.prefetch.PrefetchingStatistics;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;

@InterfaceAudience.Private
public final class BlockManagerParameters {
    private ExecutorServiceFuturePool futurePool;
    private BlockData blockData;
    private int bufferPoolSize;
    private PrefetchingStatistics prefetchingStatistics;
    private Configuration conf;
    private LocalDirAllocator localDirAllocator;
    private int maxBlocksCount;
    private DurationTrackerFactory trackerFactory;

    public ExecutorServiceFuturePool getFuturePool() {
        return this.futurePool;
    }

    public BlockData getBlockData() {
        return this.blockData;
    }

    public int getBufferPoolSize() {
        return this.bufferPoolSize;
    }

    public PrefetchingStatistics getPrefetchingStatistics() {
        return this.prefetchingStatistics;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public LocalDirAllocator getLocalDirAllocator() {
        return this.localDirAllocator;
    }

    public int getMaxBlocksCount() {
        return this.maxBlocksCount;
    }

    public DurationTrackerFactory getTrackerFactory() {
        return this.trackerFactory;
    }

    public BlockManagerParameters withFuturePool(ExecutorServiceFuturePool pool) {
        this.futurePool = pool;
        return this;
    }

    public BlockManagerParameters withBlockData(BlockData data) {
        this.blockData = data;
        return this;
    }

    public BlockManagerParameters withBufferPoolSize(int poolSize) {
        this.bufferPoolSize = poolSize;
        return this;
    }

    public BlockManagerParameters withPrefetchingStatistics(PrefetchingStatistics statistics) {
        this.prefetchingStatistics = statistics;
        return this;
    }

    public BlockManagerParameters withConf(Configuration configuration) {
        this.conf = configuration;
        return this;
    }

    public BlockManagerParameters withLocalDirAllocator(LocalDirAllocator dirAllocator) {
        this.localDirAllocator = dirAllocator;
        return this;
    }

    public BlockManagerParameters withMaxBlocksCount(int blocksCount) {
        this.maxBlocksCount = blocksCount;
        return this;
    }

    public BlockManagerParameters withTrackerFactory(DurationTrackerFactory factory) {
        this.trackerFactory = factory;
        return this;
    }
}

