/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class JsonUtils {
    private JsonUtils() {
    }

    public static JsonElement deepCopy(JsonElement from) {
        if (from.isJsonObject()) {
            JsonObject result = new JsonObject();
            for (Map.Entry entry : from.getAsJsonObject().entrySet()) {
                result.add((String)entry.getKey(), JsonUtils.deepCopy((JsonElement)entry.getValue()));
            }
            return result;
        }
        if (from.isJsonArray()) {
            JsonArray result = new JsonArray();
            for (JsonElement element : from.getAsJsonArray()) {
                result.add(element);
            }
            return result;
        }
        if (from.isJsonPrimitive()) {
            return from;
        }
        if (from.isJsonNull()) {
            return from;
        }
        return JsonNull.INSTANCE;
    }

    public static JsonElement toJsonTree(TypeAdapter typeAdapter, final JsonWriter optionsFrom, Object value) throws IOException {
        return new ConfigurableTypeAdapter(typeAdapter, null, new Configurable<JsonWriter>(){

            @Override
            public void configure(JsonWriter jsonWriter) {
                jsonWriter.setLenient(optionsFrom.isLenient());
                jsonWriter.setHtmlSafe(optionsFrom.isHtmlSafe());
                jsonWriter.setSerializeNulls(optionsFrom.getSerializeNulls());
            }
        }).toJsonTree(value);
    }

    public static <T> T fromJsonTree(TypeAdapter<T> typeAdapter, final JsonReader originalReader, JsonElement element) throws IOException {
        return (T)new ConfigurableTypeAdapter<T>(typeAdapter, new Configurable<JsonReader>(){

            @Override
            public void configure(JsonReader jsonReader) {
                jsonReader.setLenient(originalReader.isLenient());
            }
        }, null).fromJsonTree(element);
    }

    private static interface Configurable<T> {
        public void configure(T var1);
    }

    private static class ConfigurableTypeAdapter<T>
    extends TypeAdapter<T> {
        private final TypeAdapter<T> originalTypeAdapter;
        private final Configurable<JsonReader> jsonReaderConfigurable;
        private final Configurable<JsonWriter> jsonWriterConfigurable;

        public ConfigurableTypeAdapter(TypeAdapter<T> originalTypeAdapter, Configurable<JsonReader> jsonReaderConfigurable, Configurable<JsonWriter> jsonWriterConfigurable) {
            this.originalTypeAdapter = originalTypeAdapter;
            this.jsonReaderConfigurable = jsonReaderConfigurable;
            this.jsonWriterConfigurable = jsonWriterConfigurable;
        }

        public void write(JsonWriter out, T value) throws IOException {
            if (this.jsonWriterConfigurable != null) {
                this.jsonWriterConfigurable.configure(out);
            }
            this.originalTypeAdapter.write(out, value);
        }

        public T read(JsonReader in) throws IOException {
            if (this.jsonReaderConfigurable != null) {
                this.jsonReaderConfigurable.configure(in);
            }
            return (T)this.originalTypeAdapter.read(in);
        }
    }
}

