/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ignite.internal.marshaller.BinaryMode;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class MarshallerColumn {
    private static final Supplier<Object> NULL_SUPPLIER = () -> null;
    private final int schemaIndex;
    private final String name;
    private final BinaryMode type;
    private final int scale;
    @IgniteToStringExclude
    private final Supplier<Object> defValSup;

    @TestOnly
    public MarshallerColumn(String name, BinaryMode type) {
        this.schemaIndex = -1;
        this.name = name;
        this.type = type;
        this.defValSup = NULL_SUPPLIER;
        this.scale = 0;
    }

    public MarshallerColumn(int schemaIndex, String name, BinaryMode type, @Nullable Supplier<Object> defValSup, int scale) {
        this.schemaIndex = schemaIndex;
        this.name = name;
        this.type = type;
        this.defValSup = defValSup == null ? NULL_SUPPLIER : defValSup;
        this.scale = scale;
    }

    public int schemaIndex() {
        return this.schemaIndex;
    }

    public String name() {
        return this.name;
    }

    public BinaryMode type() {
        return this.type;
    }

    public Object defaultValue() {
        return this.defValSup.get();
    }

    public int scale() {
        return this.scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarshallerColumn that = (MarshallerColumn)o;
        return this.schemaIndex == that.schemaIndex && this.scale == that.scale && Objects.equals(this.name, that.name) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaIndex, this.name, this.type, this.scale});
    }
}

