/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxFinishResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtTxFinishResponse
extends GridDistributedTxFinishResponse {
    private static final long serialVersionUID = 0L;
    private static final int CHECK_COMMITTED_FLAG_MASK = 1;
    private int miniId;
    @GridDirectTransient
    private Throwable checkCommittedErr;
    private byte[] checkCommittedErrBytes;
    private GridCacheReturn retVal;

    public GridDhtTxFinishResponse() {
    }

    public GridDhtTxFinishResponse(int part, GridCacheVersion xid, IgniteUuid futId, int miniId) {
        super(part, xid, futId);
        assert (miniId != 0);
        this.miniId = miniId;
    }

    public int miniId() {
        return this.miniId;
    }

    public Throwable checkCommittedError() {
        return this.checkCommittedErr;
    }

    public void checkCommittedError(Throwable checkCommittedErr) {
        this.checkCommittedErr = checkCommittedErr;
    }

    public boolean checkCommitted() {
        return this.isFlag(1);
    }

    public void checkCommitted(boolean checkCommitted) {
        this.setFlag(checkCommitted, 1);
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.checkCommittedErr != null && this.checkCommittedErrBytes == null) {
            this.checkCommittedErrBytes = U.marshal(ctx, (Object)this.checkCommittedErr);
        }
        if (this.retVal != null && this.retVal.cacheId() != 0) {
            GridCacheContext cctx = ctx.cacheContext(this.retVal.cacheId());
            assert (cctx != null) : this.retVal.cacheId();
            this.retVal.prepareMarshal(cctx);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.checkCommittedErrBytes != null && this.checkCommittedErr == null) {
            this.checkCommittedErr = (Throwable)U.unmarshal(ctx, this.checkCommittedErrBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.retVal != null && this.retVal.cacheId() != 0) {
            GridCacheContext cctx = ctx.cacheContext(this.retVal.cacheId());
            assert (cctx != null) : this.retVal.cacheId();
            this.retVal.finishUnmarshal(cctx, ldr);
        }
    }

    public void returnValue(GridCacheReturn retVal) {
        this.retVal = retVal;
    }

    public GridCacheReturn returnValue() {
        return this.retVal;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 7: {
                if (!writer.writeByteArray("checkCommittedErrBytes", this.checkCommittedErrBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeInt("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeMessage("retVal", this.retVal)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 7: {
                this.checkCommittedErrBytes = reader.readByteArray("checkCommittedErrBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.miniId = reader.readInt("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.retVal = (GridCacheReturn)reader.readMessage("retVal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtTxFinishResponse.class);
    }

    @Override
    public short directType() {
        return 33;
    }

    @Override
    public byte fieldsCount() {
        return 10;
    }

    @Override
    public String toString() {
        StringBuilder flags = new StringBuilder();
        if (this.checkCommitted()) {
            this.appendFlag(flags, "checkComm");
        }
        return S.toString(GridDhtTxFinishResponse.class, this, "flags", (Object)flags.toString(), "super", (Object)super.toString());
    }
}

