"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeKieEditorStore = void 0;
var VsCodeKieEditorStore = (function () {
    function VsCodeKieEditorStore() {
        this.openEditors = new Set();
    }
    VsCodeKieEditorStore.prototype.addAsActive = function (editor) {
        this.activeEditor = editor;
        this.openEditors.add(editor);
    };
    VsCodeKieEditorStore.prototype.setActive = function (editor) {
        this.activeEditor = editor;
    };
    VsCodeKieEditorStore.prototype.isActive = function (editor) {
        return this.activeEditor === editor;
    };
    VsCodeKieEditorStore.prototype.setNoneActive = function () {
        this.activeEditor = undefined;
    };
    VsCodeKieEditorStore.prototype.close = function (editor) {
        this.openEditors.delete(editor);
        if (this.isActive(editor)) {
            this.setNoneActive();
        }
    };
    VsCodeKieEditorStore.prototype.get = function (uri) {
        var found;
        this.openEditors.forEach(function (editor) {
            if (editor.hasUri(uri)) {
                found = editor;
            }
        });
        return found;
    };
    return VsCodeKieEditorStore;
}());
exports.VsCodeKieEditorStore = VsCodeKieEditorStore;
//# sourceMappingURL=VsCodeKieEditorStore.js.map