import React from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { Gallery, GalleryItem } from "@patternfly/react-core/dist/js/layouts/Gallery";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import CustomDashboardCard from "../CustomDashboardCard/CustomDashboardCard";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
const CustomDashboardsGallery = ({ driver, customDashboardsDatas, isLoading, ouiaId, ouiaSafe, }) => {
    if (isLoading) {
        return (React.createElement(Bullseye, null,
            React.createElement(KogitoSpinner, { spinnerText: "Loading customDashboard...", ouiaId: "custom-dashboard-list-loading-custom-dashboard" })));
    }
    if (!isLoading && customDashboardsDatas && customDashboardsDatas.length === 0) {
        return (React.createElement(KogitoEmptyState, { type: KogitoEmptyStateType.Search, title: "No results found", body: "Try using different filters" }));
    }
    return (React.createElement(Gallery, Object.assign({ hasGutter: true, style: { margin: "25px" } }, componentOuiaProps(ouiaId, "customDashboard-gallery", ouiaSafe)), customDashboardsDatas &&
        customDashboardsDatas.map((customDashboardData, index) => (React.createElement(GalleryItem, { key: index },
            React.createElement(CustomDashboardCard, { customDashboardData: customDashboardData, key: index, driver: driver }))))));
};
export default CustomDashboardsGallery;
//# sourceMappingURL=CustomDashboardsGallery.js.map