import React from "react";
import Moment from "react-moment";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
export const getFormTypeLabel = (value) => {
    switch (value) {
        case "HTML":
            return React.createElement(Label, { variant: "outline" }, "HTML");
        case "TSX":
            return React.createElement(Label, { variant: "outline" }, "REACT");
        default:
            return value;
    }
};
export const getFormNameColumn = (selectForm) => {
    return {
        label: "Name",
        path: "name",
        bodyCellTransformer: (cellValue, rowForm) => {
            return (React.createElement("a", { onClick: () => selectForm(rowForm) },
                React.createElement("strong", null, cellValue)));
        },
        isSortable: true,
    };
};
export const getDateColumn = (columnPath, columnLabel) => {
    return {
        label: columnLabel,
        path: columnPath,
        bodyCellTransformer: (value) => React.createElement(Moment, { fromNow: true }, new Date(`${value}`)),
        isSortable: true,
    };
};
export const getFormTypeColumn = () => {
    return {
        label: "Type",
        path: "type",
        bodyCellTransformer: (cellValue) => getFormTypeLabel(cellValue),
        isSortable: true,
    };
};
//# sourceMappingURL=FormsListUtils.js.map