var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useEffect, useState } from "react";
import { DataTable } from "@kie-tools/runtime-tools-components/dist/components/DataTable";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { getFormNameColumn, getDateColumn, getFormTypeColumn } from "../FormsListUtils/FormsListUtils";
import _ from "lodash";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
const FormsTable = ({ driver, formsData, setFormsData, isLoading, ouiaId, ouiaSafe, }) => {
    const [columns] = useState([
        getFormNameColumn((formData) => driver.openForm(formData)),
        getFormTypeColumn(),
        getDateColumn("lastModified", "Last Modified"),
    ]);
    const [sortBy, setSortBy] = useState({
        property: "lastModified",
        direction: "desc",
    });
    useEffect(() => {
        if (!_.isEmpty(formsData)) {
            onSort(2, "desc");
        }
    }, [isLoading]);
    const getSortBy = () => {
        return {
            index: columns.findIndex((column) => column.path === sortBy.property),
            direction: sortBy.direction,
        };
    };
    const onSort = (index, direction) => __awaiter(void 0, void 0, void 0, function* () {
        const sortObj = {
            property: columns[index].path,
            direction: direction,
        };
        const sortedData = _.orderBy(formsData, _.keys({
            [sortObj.property]: sortObj.direction,
        }), _.values({
            [sortObj.property]: sortObj.direction,
        }));
        setFormsData(sortedData);
        setSortBy(sortObj);
    });
    const formsLoadingComponent = (React.createElement(Bullseye, null,
        React.createElement(KogitoSpinner, { spinnerText: "Loading forms...", ouiaId: "forms-list-loading-forms" })));
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "forms-table", ouiaSafe)),
        React.createElement(DataTable, { data: formsData, isLoading: isLoading, columns: columns, error: false, sortBy: getSortBy(), onSorting: onSort, LoadingComponent: formsLoadingComponent })));
};
export default FormsTable;
//# sourceMappingURL=FormsTable.js.map