import * as React from "react";
import { useImperativeHandle, useState } from "react";
import ProcessList from "./components/ProcessList/ProcessList";
import ProcessListEnvelopeViewDriver from "./ProcessListEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
export const ProcessListEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [processInitialState, setProcessInitialState] = useState({});
    useImperativeHandle(forwardedRef, () => ({
        initialize: (initialState) => {
            setEnvelopeConnectedToChannel(false);
            setProcessInitialState(initialState);
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (React.createElement(React.Fragment, null,
        React.createElement(ProcessList, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new ProcessListEnvelopeViewDriver(props.channelApi), initialState: processInitialState.initialState, singularProcessLabel: processInitialState.singularProcessLabel, pluralProcessLabel: processInitialState.pluralProcessLabel })));
});
export default ProcessListEnvelopeView;
//# sourceMappingURL=ProcessListEnvelopeView.js.map