import { MessageBusClientApi } from "@kie-tools-core/envelope-bus/dist/api";
import { BulkWorkflowInstanceActionResponse, WorkflowInstance, WorkflowInstanceFilter, WorkflowListSortBy } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { WorkflowListChannelApi, WorkflowListDriver } from "../api";
import { OperationType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
export default class WorkflowListEnvelopeViewDriver implements WorkflowListDriver {
    private readonly channelApi;
    constructor(channelApi: MessageBusClientApi<WorkflowListChannelApi>);
    initialLoad(filter: WorkflowInstanceFilter, sortBy: WorkflowListSortBy): Promise<void>;
    openWorkflow(workflow: WorkflowInstance): Promise<void>;
    applyFilter(filter: WorkflowInstanceFilter): Promise<void>;
    applySorting(sortBy: WorkflowListSortBy): Promise<void>;
    handleWorkflowSkip(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowRetry(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowAbort(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowMultipleAction(workflowInstances: WorkflowInstance[], operationType: OperationType): Promise<BulkWorkflowInstanceActionResponse>;
    query(offset: number, limit: number): Promise<WorkflowInstance[]>;
    getChildWorkflowsQuery(rootWorkflowInstanceId: string): Promise<WorkflowInstance[]>;
    openTriggerCloudEvent(workflowInstance?: WorkflowInstance): void;
}
//# sourceMappingURL=WorkflowListEnvelopeViewDriver.d.ts.map