/// <reference types="react" />
import * as ReactTable from "react-table";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { InsertRowColumnsDirection } from "../../api";
export interface BeeTableTdProps<R extends object> {
    onRowAdded?: (args: {
        beforeIndex: number;
        rowsCount: number;
        insertDirection: InsertRowColumnsDirection;
    }) => void;
    isActive: boolean;
    shouldRenderInlineButtons: boolean;
    shouldShowRowsInlineControls: boolean;
    rowIndex: number;
    row: ReactTable.Row<R>;
    columnIndex: number;
    column: ReactTable.ColumnInstance<R>;
    resizerStopBehavior: ResizerStopBehavior;
    lastColumnMinWidth?: number;
    onDataCellClick?: (columnID: string) => void;
    onDataCellKeyUp?: (columnID: string) => void;
}
export declare type HoverInfo = {
    isHovered: false;
} | {
    isHovered: true;
    part: "upper" | "lower";
};
export declare function BeeTableTd<R extends object>({ columnIndex, row, column, rowIndex, shouldRenderInlineButtons, shouldShowRowsInlineControls, resizerStopBehavior, onRowAdded, lastColumnMinWidth, onDataCellClick, onDataCellKeyUp, }: BeeTableTdProps<R>): JSX.Element;
//# sourceMappingURL=BeeTableTd.d.ts.map