import * as React from "react";
import * as ReactTable from "react-table";
import { InsertRowColumnsDirection } from "../../api";
export interface BeeTableThProps<R extends object> {
    groupType: string | undefined;
    onColumnAdded?: (args: {
        beforeIndex: number;
        currentIndex: number;
        groupType: string | undefined;
        columnsCount: number;
        insertDirection: InsertRowColumnsDirection;
    }) => void;
    className: string;
    thProps: Partial<ReactTable.TableHeaderProps>;
    onClick?: React.MouseEventHandler;
    onHeaderKeyUp?: React.KeyboardEventHandler;
    isLastLevelColumn: boolean;
    rowIndex: number;
    rowSpan: number;
    columnKey: string;
    columnIndex: number;
    column: ReactTable.ColumnInstance<R>;
    shouldShowColumnsInlineControls: boolean;
    forwardRef?: React.RefObject<HTMLTableCellElement>;
}
export declare type HoverInfo = {
    isHovered: false;
} | {
    isHovered: true;
    part: "left" | "right";
};
export declare function BeeTableTh<R extends object>({ forwardRef, onColumnAdded, children, className, thProps, onClick, onHeaderKeyUp, columnIndex, columnKey, rowIndex, rowSpan, groupType, column, isLastLevelColumn, shouldShowColumnsInlineControls: shouldShowRowsInlineControls, }: React.PropsWithChildren<BeeTableThProps<R>>): JSX.Element;
export declare function getHoverInfo(e: MouseEvent, elem: HTMLElement): HoverInfo;
//# sourceMappingURL=BeeTableTh.d.ts.map