"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeelInput = exports.EXPRESSION_PROPERTIES_SEPARATOR = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var Monaco = require("@kie-tools-core/monaco-editor");
var React = require("react");
var react_1 = require("react");
var FeelConfigs_1 = require("./FeelConfigs");
var dmn_feel_antlr4_parser_1 = require("@kie-tools/dmn-feel-antlr4-parser");
var Element_1 = require("./themes/Element");
exports.EXPRESSION_PROPERTIES_SEPARATOR = ".";
Monaco.languages.register({
    aliases: [FeelConfigs_1.MONACO_FEEL_LANGUAGE, "feel", "feel-dmn"],
    id: FeelConfigs_1.MONACO_FEEL_LANGUAGE,
    mimetypes: ["text/feel"],
});
Monaco.languages.setMonarchTokensProvider(FeelConfigs_1.MONACO_FEEL_LANGUAGE, (0, FeelConfigs_1.feelTokensConfig)());
Monaco.editor.defineTheme(FeelConfigs_1.MONACO_FEEL_THEME, (0, FeelConfigs_1.feelTheme)());
var __firstTimeInitializingMonacoToEnableColorizingCorrectly = true;
function getTokenTypeIndex(symbolType) {
    switch (symbolType) {
        default:
        case dmn_feel_antlr4_parser_1.FeelSyntacticSymbolNature.LocalVariable:
        case dmn_feel_antlr4_parser_1.FeelSyntacticSymbolNature.GlobalVariable:
            return Element_1.Element.Variable;
        case dmn_feel_antlr4_parser_1.FeelSyntacticSymbolNature.DynamicVariable:
            return Element_1.Element.DynamicVariable;
        case dmn_feel_antlr4_parser_1.FeelSyntacticSymbolNature.Unknown:
            return Element_1.Element.UnknownVariable;
        case dmn_feel_antlr4_parser_1.FeelSyntacticSymbolNature.Invocable:
            return Element_1.Element.FunctionCall;
        case dmn_feel_antlr4_parser_1.FeelSyntacticSymbolNature.Parameter:
            return Element_1.Element.FunctionParameterVariable;
    }
}
exports.FeelInput = React.forwardRef(function (_a, forwardRef) {
    var enabled = _a.enabled, value = _a.value, suggestionProvider = _a.suggestionProvider, onBlur = _a.onBlur, onPreviewChanged = _a.onPreviewChanged, onKeyDown = _a.onKeyDown, onChange = _a.onChange, options = _a.options, feelVariables = _a.feelVariables, expressionId = _a.expressionId;
    var monacoContainer = (0, react_1.useRef)(null);
    var monacoRef = (0, react_1.useRef)();
    var _b = __read((0, react_1.useState)(), 2), currentParsedExpression = _b[0], setCurrentParsedExpression = _b[1];
    var getLastValidSymbolAtPosition = (0, react_1.useCallback)(function (currentParsedExpression, position) {
        var lastValidSymbol;
        for (var i = 0; i < currentParsedExpression.feelVariables.length; i++) {
            var feelVariable = currentParsedExpression.feelVariables[i];
            if (feelVariable.startIndex < position && position <= feelVariable.startIndex + feelVariable.length) {
                lastValidSymbol = feelVariable;
                var target = i - 1;
                if (target < currentParsedExpression.feelVariables.length &&
                    0 <= target &&
                    lastValidSymbol.feelSymbolNature === dmn_feel_antlr4_parser_1.FeelSyntacticSymbolNature.Unknown) {
                    lastValidSymbol = currentParsedExpression.feelVariables[target];
                }
                break;
            }
        }
        return lastValidSymbol;
    }, []);
    var getSymbolAtPosition = (0, react_1.useCallback)(function (currentParsedExpression, position) {
        var e_1, _a;
        try {
            for (var _b = __values(currentParsedExpression.feelVariables), _c = _b.next(); !_c.done; _c = _b.next()) {
                var feelVariable = _c.value;
                if (feelVariable.startIndex < position && position <= feelVariable.startIndex + feelVariable.length) {
                    return feelVariable;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return undefined;
    }, []);
    var getDefaultCompletionItems = (0, react_1.useCallback)(function (suggestionProvider, model, position) {
        if (suggestionProvider) {
            var items = suggestionProvider(model.getValue(), position.lineNumber, position.column - 1);
            if (items.length > 0) {
                return items;
            }
        }
        return (0, FeelConfigs_1.feelDefaultSuggestions)();
    }, []);
    (0, react_1.useEffect)(function () {
        if (!__firstTimeInitializingMonacoToEnableColorizingCorrectly) {
            return;
        }
        console.info("Registered FEEL language on Monaco Editor to enable correct 'colorize' call.");
        Monaco.editor
            .create(monacoContainer.current, {
            theme: FeelConfigs_1.MONACO_FEEL_THEME,
            language: FeelConfigs_1.MONACO_FEEL_LANGUAGE,
            "semanticHighlighting.enabled": true,
        })
            .dispose();
        __firstTimeInitializingMonacoToEnableColorizingCorrectly = false;
    }, []);
    var completionItemProvider = (0, react_1.useCallback)(function () {
        return {
            triggerCharacters: [exports.EXPRESSION_PROPERTIES_SEPARATOR],
            provideCompletionItems: function (model, position) {
                var e_2, _a, e_3, _b;
                var completionItems = getDefaultCompletionItems(suggestionProvider, model, position);
                var variablesSuggestions = new Array();
                if (currentParsedExpression) {
                    var pos = position.column - 1;
                    var expression = model.getValue();
                    var currentChar = expression.charAt(pos - 1);
                    if (currentChar === exports.EXPRESSION_PROPERTIES_SEPARATOR || currentChar === " ") {
                        pos--;
                    }
                    var lastValidSymbol = getLastValidSymbolAtPosition(currentParsedExpression, pos);
                    if (lastValidSymbol &&
                        lastValidSymbol.feelSymbolNature !== dmn_feel_antlr4_parser_1.FeelSyntacticSymbolNature.Unknown &&
                        expression.charAt(lastValidSymbol.startIndex + lastValidSymbol.length) === ".") {
                        try {
                            for (var _c = __values(lastValidSymbol.scopeSymbols), _d = _c.next(); !_d.done; _d = _c.next()) {
                                var scopeSymbol = _d.value;
                                variablesSuggestions.push({
                                    kind: Monaco.languages.CompletionItemKind.Variable,
                                    label: scopeSymbol.name,
                                    insertText: scopeSymbol.name,
                                    detail: scopeSymbol.type,
                                    range: {
                                        startLineNumber: lastValidSymbol.startLine + 1,
                                        endLineNumber: lastValidSymbol.endLine + 1,
                                        startColumn: lastValidSymbol.startIndex + lastValidSymbol.length + 2,
                                        endColumn: lastValidSymbol.startIndex + lastValidSymbol.length + 2 + scopeSymbol.name.length,
                                    },
                                });
                            }
                        }
                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                        finally {
                            try {
                                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                            }
                            finally { if (e_2) throw e_2.error; }
                        }
                    }
                    else {
                        var currentSymbol = getSymbolAtPosition(currentParsedExpression, pos);
                        try {
                            for (var _e = __values(currentParsedExpression.availableSymbols), _f = _e.next(); !_f.done; _f = _e.next()) {
                                var scopeSymbol = _f.value;
                                if (currentSymbol && scopeSymbol.name.startsWith(currentSymbol.text)) {
                                    variablesSuggestions.push({
                                        kind: Monaco.languages.CompletionItemKind.Variable,
                                        label: scopeSymbol.name,
                                        insertText: scopeSymbol.name,
                                        detail: scopeSymbol.type,
                                        sortText: "1",
                                        range: {
                                            startLineNumber: currentSymbol.startLine + 1,
                                            endLineNumber: currentSymbol.endLine + 1,
                                            startColumn: currentSymbol.startIndex + 1,
                                            endColumn: currentSymbol.startIndex + 1 + scopeSymbol.name.length,
                                        },
                                    });
                                }
                                else {
                                    variablesSuggestions.push({
                                        kind: Monaco.languages.CompletionItemKind.Variable,
                                        label: scopeSymbol.name,
                                        insertText: scopeSymbol.name,
                                        detail: scopeSymbol.type,
                                        sortText: "2",
                                    });
                                }
                            }
                        }
                        catch (e_3_1) { e_3 = { error: e_3_1 }; }
                        finally {
                            try {
                                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                            }
                            finally { if (e_3) throw e_3.error; }
                        }
                        variablesSuggestions.push.apply(variablesSuggestions, __spreadArray([], __read(completionItems), false));
                    }
                    return {
                        suggestions: variablesSuggestions,
                    };
                }
                return {
                    suggestions: completionItems,
                };
            },
        };
    }, [
        currentParsedExpression,
        getDefaultCompletionItems,
        getLastValidSymbolAtPosition,
        getSymbolAtPosition,
        suggestionProvider,
    ]);
    (0, react_1.useEffect)(function () {
        if (!enabled) {
            return;
        }
        var disposable = Monaco.languages.registerCompletionItemProvider(FeelConfigs_1.MONACO_FEEL_LANGUAGE, completionItemProvider());
        return function () {
            disposable.dispose();
        };
    }, [completionItemProvider, currentParsedExpression, enabled, suggestionProvider]);
    (0, react_1.useEffect)(function () {
        if (!enabled) {
            return;
        }
        var disposable = Monaco.languages.registerDocumentSemanticTokensProvider({ language: FeelConfigs_1.MONACO_FEEL_LANGUAGE }, {
            provideDocumentSemanticTokens: function (model) {
                var e_4, _a, e_5, _b;
                var tokenTypes = new Array();
                if (feelVariables) {
                    var text = model.getValue();
                    var contentByLines = model.getLinesContent();
                    var startOfPreviousToken = 0;
                    var previousLine = 0;
                    var lineOffset = 0;
                    var currentLine = 0;
                    var parsedExpression = feelVariables.parser.parse(expressionId !== null && expressionId !== void 0 ? expressionId : "", text);
                    setCurrentParsedExpression(parsedExpression);
                    try {
                        for (var _c = __values(parsedExpression.feelVariables), _d = _c.next(); !_d.done; _d = _c.next()) {
                            var variable = _d.value;
                            if (variable.startLine != currentLine) {
                                lineOffset += contentByLines[currentLine].length + 1;
                                currentLine = variable.startLine;
                            }
                            variable.startIndex -= lineOffset;
                        }
                    }
                    catch (e_4_1) { e_4 = { error: e_4_1 }; }
                    finally {
                        try {
                            if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                        }
                        finally { if (e_4) throw e_4.error; }
                    }
                    try {
                        for (var _e = __values(parsedExpression.feelVariables), _f = _e.next(); !_f.done; _f = _e.next()) {
                            var variable = _f.value;
                            if (previousLine != variable.startLine) {
                                startOfPreviousToken = 0;
                            }
                            if (variable.startLine === variable.endLine) {
                                tokenTypes.push(variable.startLine - previousLine, variable.startIndex - startOfPreviousToken, variable.length, getTokenTypeIndex(variable.feelSymbolNature), 0);
                                previousLine = variable.startLine;
                                startOfPreviousToken = variable.startIndex;
                            }
                            else {
                                tokenTypes.push(variable.startLine - previousLine, variable.startIndex - startOfPreviousToken, variable.length, getTokenTypeIndex(variable.feelSymbolNature), 0);
                                var length_1 = variable.length - (contentByLines[variable.startLine].length - variable.startIndex + 1);
                                tokenTypes.push(variable.endLine - variable.startLine, 0, length_1, getTokenTypeIndex(variable.feelSymbolNature), 0);
                                startOfPreviousToken = 0;
                                previousLine = variable.endLine;
                            }
                        }
                    }
                    catch (e_5_1) { e_5 = { error: e_5_1 }; }
                    finally {
                        try {
                            if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                        }
                        finally { if (e_5) throw e_5.error; }
                    }
                }
                return {
                    data: new Uint32Array(tokenTypes),
                    resultId: undefined,
                };
            },
            getLegend: function () {
                return {
                    tokenTypes: Object.values(Element_1.Element).filter(function (x) { return typeof x === "string"; }),
                    tokenModifiers: [],
                };
            },
            releaseDocumentSemanticTokens: function (resultId) {
            },
        });
        return function () {
            disposable.dispose();
        };
    }, [enabled, expressionId, feelVariables]);
    var config = (0, react_1.useMemo)(function () {
        return (0, FeelConfigs_1.feelDefaultConfig)(options);
    }, [options]);
    (0, react_1.useEffect)(function () {
        if (enabled && !monacoRef.current) {
            var element = monacoContainer.current;
            var editor_1 = Monaco.editor.create(element, config);
            editor_1.onDidChangeModelContent(function (event) {
                var value = editor_1.getValue();
                Monaco.editor.colorize(value, FeelConfigs_1.MONACO_FEEL_LANGUAGE, {}).then(function (colorizedValue) {
                    onChange === null || onChange === void 0 ? void 0 : onChange(event, value, colorizedValue);
                });
            });
            editor_1.onDidBlurEditorWidget(function () {
                onBlur === null || onBlur === void 0 ? void 0 : onBlur(editor_1.getValue());
            });
            editor_1.onKeyDown(function (e) {
                onKeyDown === null || onKeyDown === void 0 ? void 0 : onKeyDown(e, editor_1.getValue());
            });
            editor_1.focus();
            monacoRef.current = editor_1;
        }
    }, [config, enabled, onBlur, onChange, onKeyDown]);
    (0, react_1.useEffect)(function () {
        var _a, _b;
        if (enabled) {
            (_a = monacoRef.current) === null || _a === void 0 ? void 0 : _a.setValue(value !== null && value !== void 0 ? value : "");
            (_b = monacoRef.current) === null || _b === void 0 ? void 0 : _b.setPosition(calculatePosition(value !== null && value !== void 0 ? value : ""));
        }
    }, [value, enabled]);
    (0, react_1.useEffect)(function () {
        var _a, _b;
        if (!enabled && monacoRef.current) {
            onBlur === null || onBlur === void 0 ? void 0 : onBlur((_a = monacoRef.current) === null || _a === void 0 ? void 0 : _a.getValue());
            (_b = monacoRef.current) === null || _b === void 0 ? void 0 : _b.dispose();
            monacoRef.current = undefined;
        }
    }, [enabled, onBlur]);
    (0, react_1.useEffect)(function () {
        Monaco.editor.colorize(value !== null && value !== void 0 ? value : "", FeelConfigs_1.MONACO_FEEL_LANGUAGE, {}).then(function (colorizedValue) {
            onPreviewChanged === null || onPreviewChanged === void 0 ? void 0 : onPreviewChanged(colorizedValue);
        });
    }, [onPreviewChanged, value]);
    (0, react_1.useImperativeHandle)(forwardRef, function () { return ({
        setMonacoValue: function (newValue) { var _a; return (_a = monacoRef.current) === null || _a === void 0 ? void 0 : _a.setValue(newValue); },
        getMonacoValue: function () { var _a; return (_a = monacoRef.current) === null || _a === void 0 ? void 0 : _a.getValue(); },
        insertNewLineToMonaco: function () { var _a; return (_a = monacoRef.current) === null || _a === void 0 ? void 0 : _a.trigger("keyboard", "type", { text: "\n" }); },
        isSuggestionWidgetOpen: function () { var _a, _b; return (_b = (_a = monacoRef.current) === null || _a === void 0 ? void 0 : _a._contentWidgets["editor.widget.suggestWidget"]) === null || _b === void 0 ? void 0 : _b.position; },
    }); });
    return ((0, jsx_runtime_1.jsx)("div", __assign({ className: "feel-input" }, { children: (0, jsx_runtime_1.jsx)("div", { ref: monacoContainer, role: "textbox", "data-testid": "monaco-container" }) })));
});
function calculatePosition(value) {
    var lines = value.split("\n");
    var lineNumber = lines.length;
    var column = lines[lineNumber - 1].length + 1;
    return { lineNumber: lineNumber, column: column };
}
//# sourceMappingURL=FeelInput.js.map