"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.regressionModelFactory = exports.REGRESSION_MODEL = void 0;
var pmml4_4_1 = require("../../model/pmml4_4");
var LocalTransformations_1 = require("./LocalTransformations");
var MiningSchema_1 = require("./MiningSchema");
var ModelExplanation_1 = require("./ModelExplanation");
var ModelStats_1 = require("./ModelStats");
var ModelVerification_1 = require("./ModelVerification");
var Output_1 = require("./Output");
var Targets_1 = require("./Targets");
var NUMERIC_PREDICTOR = "\n\"NumericPredictor\": $singletonArray(\n  $v.elements[(name = \"NumericPredictor\")] ~> $map(function($v, $i) {\n    $merge([\n      $v.attributes,\n      {\n        \"exponent\": $number($v.attributes.exponent),\n        \"coefficient\": $number($v.attributes.coefficient)\n      }\n    ])\n  })\n)";
var CATEGORICAL_PREDICTOR = "\n\"CategoricalPredictor\": $singletonArray(\n  $v.elements[(name = \"CategoricalPredictor\")] ~> $map(function($v, $i) {\n    $merge([\n      $v.attributes,\n      {\n        \"coefficient\": $number($v.attributes.coefficient)\n      }\n    ])\n  })\n)";
var PREDICTOR_TERM = "\n  \"PredictorTerm\": $v.elements[(name = \"PredictorTerm\")] ~> $map(function($v, $i) {\n    $v\n})";
var REGRESSION_TABLE = "\n\"RegressionTable\": $singletonArray(\n  $v.elements[(name = \"RegressionTable\")] ~> $map(function($v, $i) {\n    $merge([\n      $v.attributes,\n      {\n        \"intercept\": $number($v.attributes.intercept)\n      },\n      {\n        ".concat(NUMERIC_PREDICTOR, ",\n        ").concat(CATEGORICAL_PREDICTOR, ",\n        ").concat(PREDICTOR_TERM, "\n      }\n    ])\n  })\n)");
exports.REGRESSION_MODEL = "\nelements.elements[(name = \"RegressionModel\")] ~> $map(function($v, $i) {\n  $merge([\n    $regressionModelFactory(),\n    $v.attributes,\n    {\n      \"_type\": $v.name\n    },\n    {\n      ".concat(MiningSchema_1.MINING_SCHEMA, ", \n      ").concat(Output_1.OUTPUT, ",\n      ").concat(ModelStats_1.MODEL_STATS, ",\n      ").concat(ModelExplanation_1.MODEL_EXPLANATION, ",\n      ").concat(ModelVerification_1.MODEL_VERIFICATION, ",\n      ").concat(Targets_1.TARGETS, ",\n      ").concat(LocalTransformations_1.LOCAL_TRANSFORMATIONS, ",\n      ").concat(REGRESSION_TABLE, "\n    }\n  ])\n})");
function regressionModelFactory() {
    return new pmml4_4_1.RegressionModel({
        MiningSchema: new pmml4_4_1.MiningSchema({ MiningField: [] }),
        RegressionTable: [new pmml4_4_1.RegressionTable({ intercept: 0.0 })],
        functionName: "regression",
    });
}
exports.regressionModelFactory = regressionModelFactory;
//# sourceMappingURL=RegressionModel.js.map