var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { DmnBuiltInDataType, generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { Select, SelectGroup, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { useCallback, useRef, useState } from "react";
import { TypeRefLabel } from "./TypeRefLabel";
import { ArrowUpIcon } from "@patternfly/react-icons/dist/js/icons/arrow-up-icon";
import { DmnEditorTab } from "../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { builtInFeelTypeNames, builtInFeelTypes } from "./BuiltInFeelTypes";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { useInViewSelect } from "../responsiveness/useInViewSelect";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
export function TypeRefSelector(_a) {
    var zoom = _a.zoom, heightRef = _a.heightRef, onChange = _a.onChange, typeRef = _a.typeRef, isDisabled = _a.isDisabled, menuAppendTo = _a.menuAppendTo, onCreate = _a.onCreate, onToggle = _a.onToggle, removeDataTypes = _a.removeDataTypes;
    var _b = __read(useState(false), 2), isOpen = _b[0], setOpen = _b[1];
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var selectedDataType = useDmnEditorStore(function (s) {
        return typeRef
            ? s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelDataTypesByFeelName.get(typeRef)
            : undefined;
    });
    var _onToggle = useCallback(function (isExpanded) {
        onToggle === null || onToggle === void 0 ? void 0 : onToggle(isExpanded);
        setOpen(isExpanded);
    }, [onToggle]);
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _c = useDmnEditorStore(function (state) {
        var customDataTypes = [];
        var externalDataTypes = [];
        __spreadArray([], __read(state.computed(state).getDataTypes(externalModelsByNamespace).allTopLevelDataTypesByFeelName.values()), false).forEach(function (s) {
            if (s.parentId) {
                return;
            }
            if (s.namespace === state.dmn.model.definitions["@_namespace"]) {
                if ((removeDataTypes !== null && removeDataTypes !== void 0 ? removeDataTypes : []).findIndex(function (removeDataType) { return removeDataType.feelName === s.feelName; }) < 0) {
                    customDataTypes.push(s);
                }
            }
            else {
                externalDataTypes.push(s);
            }
        });
        return { customDataTypes: customDataTypes, externalDataTypes: externalDataTypes };
    }), customDataTypes = _c.customDataTypes, externalDataTypes = _c.externalDataTypes;
    var exists = selectedDataType || (typeRef && builtInFeelTypeNames.has(typeRef));
    var id = generateUuid();
    var toggleRef = useRef(null);
    var _d = useInViewSelect(heightRef !== null && heightRef !== void 0 ? heightRef : { current: document.body }, toggleRef, zoom !== null && zoom !== void 0 ? zoom : 1), maxHeight = _d.maxHeight, direction = _d.direction;
    return (_jsxs(Flex, __assign({ id: id, justifyContent: { default: "justifyContentFlexStart" }, flexWrap: { default: "nowrap" }, spaceItems: { default: "spaceItemsNone" } }, { children: [(selectedDataType === null || selectedDataType === void 0 ? void 0 : selectedDataType.itemDefinition) && (_jsx(Button, __assign({ title: "Jump to definition", className: "kie-dmn-editor--data-type-jump-to-definition", variant: ButtonVariant.control, onClick: function (e) {
                    return dmnEditorStoreApi.setState(function (state) {
                        var _a;
                        state.navigation.tab = DmnEditorTab.DATA_TYPES;
                        state.dataTypesEditor.activeItemDefinitionId = (_a = selectedDataType === null || selectedDataType === void 0 ? void 0 : selectedDataType.itemDefinition) === null || _a === void 0 ? void 0 : _a["@_id"];
                    });
                } }, { children: _jsx(ArrowUpIcon, {}) }))), _jsxs(Select, __assign({ toggleRef: toggleRef, className: !exists && typeRef ? "kie-dmn-editor--type-ref-selector-invalid-value" : undefined, isDisabled: isDisabled, variant: SelectVariant.typeahead, typeAheadAriaLabel: DmnBuiltInDataType.Undefined, onToggle: _onToggle, onSelect: function (e, v) {
                    _onToggle(false);
                    onChange(v === DmnBuiltInDataType.Undefined ? undefined : v);
                }, selections: typeRef !== null && typeRef !== void 0 ? typeRef : DmnBuiltInDataType.Undefined, isOpen: isOpen, "aria-labelledby": "Data types selector", placeholderText: "Select a data type...", isCreatable: !!onCreate, isCreateOptionOnTop: false, onCreateOption: onCreate, isGrouped: true, menuAppendTo: menuAppendTo !== null && menuAppendTo !== void 0 ? menuAppendTo : document.body, maxHeight: maxHeight, direction: direction, onWheelCapture: function (e) { return e.stopPropagation(); } }, { children: [_jsx(SelectGroup, __assign({ label: "Built-in", style: { minWidth: "300px" } }, { children: builtInFeelTypes.map(function (dt) { return (_jsx(SelectOption, __assign({ value: dt.name }, { children: dt.name }), dt.name)); }) }), "builtin"), _jsx(SelectGroup, __assign({ label: "Custom", style: { minWidth: "300px" } }, { children: (customDataTypes.length > 0 &&
                            customDataTypes.map(function (dt) {
                                var _a, _b;
                                return (_jsxs(SelectOption, __assign({ value: dt.feelName }, { children: [dt.feelName, "\u00A0", _jsx(TypeRefLabel, { typeRef: (_a = dt.itemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text, relativeToNamespace: dt.namespace, isCollection: (_b = dt.itemDefinition) === null || _b === void 0 ? void 0 : _b["@_isCollection"] })] }), dt.feelName));
                            })) || _jsx(SelectOption, { value: "None", isDisabled: true }, "None") }), "custom"), _jsx(SelectGroup, __assign({ label: "External", style: { minWidth: "300px" } }, { children: (externalDataTypes.length > 0 &&
                            externalDataTypes.map(function (dt) {
                                var _a, _b;
                                return (_jsxs(SelectOption, __assign({ value: dt.feelName }, { children: [dt.feelName, "\u00A0", _jsx(TypeRefLabel, { typeRef: (_a = dt.itemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text, relativeToNamespace: dt.namespace, isCollection: (_b = dt.itemDefinition) === null || _b === void 0 ? void 0 : _b["@_isCollection"] })] }), dt.feelName));
                            })) || _jsx(SelectOption, { value: "None", isDisabled: true }, "None") }), "external")] }))] })));
}
//# sourceMappingURL=TypeRefSelector.js.map