import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { deleteEdgeWaypoint } from "../../mutations/deleteEdgeWaypoint";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { drag } from "d3-drag";
import { select } from "d3-selection";
import { useEffect } from "react";
import { repositionEdgeWaypoint } from "../../mutations/repositionEdgeWaypoint";
import { snapPoint } from "../SnapGrid";
export function PotentialWaypoint(props) {
    return _jsx("circle", { className: "kie-dmn-editor--edge-waypoint-potential", r: 5, cx: props.point.x, cy: props.point.y });
}
export function Waypoints(props) {
    return (_jsx(_Fragment, { children: props.waypoints.slice(1, -1).map(function (p, i) { return (_jsx(Waypoint, { onDragStop: props.onDragStop, edgeIndex: props.edgeIndex, edgeId: props.edgeId, point: p, index: i + 1 }, i)); }) }));
}
export function Waypoint(_a) {
    var edgeId = _a.edgeId, edgeIndex = _a.edgeIndex, index = _a.index, point = _a.point, onDragStop = _a.onDragStop;
    var circleRef = React.useRef(null);
    var diagram = useDmnEditorStore(function (s) { return s.diagram; });
    var drdIndex = useDmnEditorStore(function (s) { return s.computed(s).getDrdIndex(); });
    var setState = useDmnEditorStoreApi().setState;
    useEffect(function () {
        if (!circleRef.current) {
            return;
        }
        var selection = select(circleRef.current);
        var dragHandler = drag()
            .on("start", function () {
            setState(function (state) { return state.dispatch(state).diagram.setEdgeStatus(edgeId, { draggingWaypoint: true }); });
        })
            .on("drag", function (e) {
            setState(function (state) {
                repositionEdgeWaypoint({
                    definitions: state.dmn.model.definitions,
                    drdIndex: drdIndex,
                    edgeIndex: edgeIndex,
                    waypointIndex: index,
                    waypoint: snapPoint(diagram.snapGrid, { "@_x": e.x, "@_y": e.y }),
                });
            });
        })
            .on("end", function (e) {
            onDragStop(e.sourceEvent);
            setState(function (state) { return state.dispatch(state).diagram.setEdgeStatus(edgeId, { draggingWaypoint: false }); });
        });
        selection.call(dragHandler);
        return function () {
            selection.on(".drag", null);
        };
    }, [drdIndex, diagram.snapGrid, edgeId, edgeIndex, index, onDragStop, setState]);
    return (_jsx("circle", { "data-waypointindex": index, ref: circleRef, className: "kie-dmn-editor--diagram-edge-waypoint", cx: point["@_x"], cy: point["@_y"], r: 1, onDoubleClick: function (e) {
            e.preventDefault();
            e.stopPropagation();
            setState(function (state) {
                deleteEdgeWaypoint({
                    definitions: state.dmn.model.definitions,
                    drdIndex: drdIndex,
                    edgeIndex: edgeIndex,
                    waypointIndex: index,
                });
            });
        } }));
}
//# sourceMappingURL=Waypoints.js.map