import { DMN15__tDefinitions } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import { Unpacked } from "../../tsExt/tsExt";
import { Normalized } from "../../normalization/normalize";
export declare type AdjMatrix = Record<string, undefined | Record<string, undefined | {
    direction: HierarchyDirection;
    edge: DrgEdge;
}>>;
export declare type HierarchyDirection = "up" | "down";
export declare type DrgEdge = {
    sourceId: string;
    targetId: string;
    id: string;
    dmnObject: {
        namespace: string;
        id: string;
        type: Unpacked<Normalized<DMN15__tDefinitions>["artifact" | "drgElement"]>["__$$element"];
        requirementType: "informationRequirement" | "knowledgeRequirement" | "authorityRequirement" | "association";
        index: number;
    };
};
export declare type DrgAdjacencyList = Map<string, {
    dependencies: Set<string>;
}>;
export declare function getAdjMatrix(edges: DrgEdge[]): AdjMatrix;
export declare type NodeVisitor = (nodeId: string, traversalDirection: HierarchyDirection) => void;
export declare type EdgeVisitor = (edge: DrgEdge, traversalDirection: HierarchyDirection) => void;
export declare function traverse(__adjMatrix: AdjMatrix, originalStartingNodeIds: Set<string>, curNodeIds: string[], traversalDirection: HierarchyDirection, nodeVisitor?: NodeVisitor, edgeVisitor?: EdgeVisitor, visited?: Set<string>): void;
export declare function buildHierarchy({ nodeId, edges }: {
    nodeId: string | undefined | null;
    edges: DrgEdge[];
}): {
    dependencies: Set<string>;
    dependents: Set<string>;
};
//# sourceMappingURL=graph.d.ts.map