var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useEffect, useLayoutEffect, useMemo, useRef, useState } from "react";
import { EmptyLabel } from "./Nodes";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { buildFeelQNameFromXmlQName } from "../../feel/buildFeelQName";
import { Truncate } from "@patternfly/react-core/dist/js/components/Truncate";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { invalidInlineFeelNameStyle } from "../../feel/InlineFeelNameInput";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { useFocusableElement } from "../../focus/useFocusableElement";
import { flushSync } from "react-dom";
import "./EditableNodeLabel.css";
export function EditableNodeLabel(_a) {
    var id = _a.id, namedElement = _a.namedElement, namedElementQName = _a.namedElementQName, _isEditing = _a.isEditing, _setEditing = _a.setEditing, value = _a.value, onChange = _a.onChange, position = _a.position, truncate = _a.truncate, grow = _a.grow, shouldCommitOnBlur = _a.shouldCommitOnBlur, skipValidation = _a.skipValidation, onGetAllUniqueNames = _a.onGetAllUniqueNames, fontCssProperties = _a.fontCssProperties, setLabelHeight = _a.setLabelHeight, enableAutoFocusing = _a.enableAutoFocusing;
    var displayValue = useDmnEditorStore(function (s) {
        if (!value) {
            return undefined;
        }
        if (!namedElement || !namedElementQName) {
            return value;
        }
        var feelName = buildFeelQNameFromXmlQName({
            namedElement: namedElement,
            importsByNamespace: s.computed(s).importsByNamespace(),
            model: s.dmn.model.definitions,
            namedElementQName: namedElementQName,
            relativeToNamespace: s.dmn.model.definitions["@_namespace"],
        });
        return feelName.full;
    });
    var isEditing = useMemo(function () {
        return !(namedElementQName === null || namedElementQName === void 0 ? void 0 : namedElementQName.prefix) && _isEditing;
    }, [_isEditing, namedElementQName === null || namedElementQName === void 0 ? void 0 : namedElementQName.prefix]);
    var setEditing = useCallback(function (args) {
        if (namedElementQName === null || namedElementQName === void 0 ? void 0 : namedElementQName.prefix) {
            return;
        }
        _setEditing(args);
    }, [_setEditing, namedElementQName === null || namedElementQName === void 0 ? void 0 : namedElementQName.prefix]);
    var _b = __read(useState(displayValue), 2), internalValue = _b[0], setInternalValue = _b[1];
    useEffect(function () {
        setInternalValue(displayValue);
    }, [displayValue]);
    var _shouldCommitOnBlur = shouldCommitOnBlur !== null && shouldCommitOnBlur !== void 0 ? shouldCommitOnBlur : false;
    var _c = __read(useState(_shouldCommitOnBlur), 2), shouldCommit = _c[0], setShouldCommit = _c[1];
    useEffect(function () {
        setShouldCommit(_shouldCommitOnBlur);
    }, [_shouldCommitOnBlur]);
    var restoreFocus = useCallback(function () {
        setTimeout(function () {
            var _a, _b;
            if (document.activeElement === ref.current) {
                (_b = (_a = previouslyFocusedElement.current) === null || _a === void 0 ? void 0 : _a.focus) === null || _b === void 0 ? void 0 : _b.call(_a);
            }
        }, 0);
    }, []);
    var isValid = useDmnEditorStore(function (s) {
        var _a;
        if (skipValidation) {
            return true;
        }
        return DMN15_SPEC.namedElement.isValidName((_a = namedElement === null || namedElement === void 0 ? void 0 : namedElement["@_id"]) !== null && _a !== void 0 ? _a : generateUuid(), internalValue, onGetAllUniqueNames(s));
    });
    var onBlur = useCallback(function () {
        setEditing(false);
        setShouldCommit(_shouldCommitOnBlur);
        restoreFocus();
        if (isValid && internalValue !== value && shouldCommit) {
            onChange(internalValue);
        }
        else {
            console.debug("Label change cancelled for node with label ".concat(value));
            setInternalValue(value);
        }
    }, [internalValue, onChange, restoreFocus, _shouldCommitOnBlur, setEditing, shouldCommit, isValid, value]);
    var onKeyDown = useCallback(function (e) {
        e.stopPropagation();
        if (e.key === "Enter") {
            if (!isValid) {
                return;
            }
            else {
                setShouldCommit(true);
                restoreFocus();
            }
        }
        else if (e.key === "Escape") {
            setShouldCommit(false);
            restoreFocus();
        }
    }, [restoreFocus, isValid]);
    var previouslyFocusedElement = useRef();
    useLayoutEffect(function () {
        var _a, _b;
        if (isEditing) {
            previouslyFocusedElement.current = (_a = document.activeElement) !== null && _a !== void 0 ? _a : undefined;
            (_b = ref.current) === null || _b === void 0 ? void 0 : _b.focus();
        }
    }, [isEditing]);
    useLayoutEffect(function () {
        var _a;
        if (isEditing) {
            (_a = ref.current) === null || _a === void 0 ? void 0 : _a.setSelectionRange(0, 0);
        }
    }, [isEditing]);
    useEffect(function () {
        var _a, _b;
        if (isEditing) {
            (_a = ref.current) === null || _a === void 0 ? void 0 : _a.setSelectionRange(0, (_b = ref.current) === null || _b === void 0 ? void 0 : _b.value.length, "forward");
        }
    }, [isEditing]);
    var ref = useRef(null);
    useFocusableElement(ref, (enableAutoFocusing !== null && enableAutoFocusing !== void 0 ? enableAutoFocusing : true) ? id !== null && id !== void 0 ? id : namedElement === null || namedElement === void 0 ? void 0 : namedElement["@_id"] : undefined, useCallback(function (cb) {
        setTimeout(function () {
            flushSync(function () {
                setEditing(true);
            });
            cb();
        }, 100);
    }, [setEditing]));
    return (_jsx("div", __assign({ className: "kie-dmn-editor--editable-node-name-input ".concat(position, " ").concat(grow ? "grow" : "", " ").concat((namedElementQName === null || namedElementQName === void 0 ? void 0 : namedElementQName.prefix) ? "kie-dmn-editor--node-external" : "") }, { children: (isEditing && (_jsx("input", { spellCheck: "false", style: __assign(__assign({}, fontCssProperties), (isValid ? {} : invalidInlineFeelNameStyle)), onMouseDownCapture: function (e) { return e.stopPropagation(); }, onKeyDown: onKeyDown, tabIndex: -1, ref: ref, onBlur: onBlur, onChange: function (e) { return setInternalValue(e.target.value); }, value: internalValue }))) || (_jsx("span", __assign({ ref: function (ref) { var _a; return setLabelHeight === null || setLabelHeight === void 0 ? void 0 : setLabelHeight((_a = ref === null || ref === void 0 ? void 0 : ref.clientHeight) !== null && _a !== void 0 ? _a : 0); }, style: __assign(__assign({ whiteSpace: "pre-wrap" }, fontCssProperties), (isValid ? {} : invalidInlineFeelNameStyle)) }, { children: !displayValue ? (_jsx(EmptyLabel, {})) : !truncate ? (displayValue) : (_jsx(Truncate, { content: displayValue, tooltipPosition: "right-end" })) }))) })));
}
export function useEditableNodeLabel(id) {
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _a = __read(useState(!!id && !!dmnEditorStoreApi.getState().focus.consumableId && dmnEditorStoreApi.getState().focus.consumableId === id), 2), isEditingLabel = _a[0], setEditingLabel = _a[1];
    var triggerEditing = useCallback(function (e) {
        e.stopPropagation();
        e.preventDefault();
        setEditingLabel(true);
    }, []);
    var triggerEditingIfEnter = useCallback(function (e) {
        if (e.key === "Enter") {
            triggerEditing(e);
        }
    }, [triggerEditing]);
    return useMemo(function () { return ({ isEditingLabel: isEditingLabel, setEditingLabel: setEditingLabel, triggerEditing: triggerEditing, triggerEditingIfEnter: triggerEditingIfEnter }); }, [isEditingLabel, triggerEditing, triggerEditingIfEnter]);
}
//# sourceMappingURL=EditableNodeLabel.js.map