var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import "./Draggable.css";
import * as React from "react";
import { useState, useCallback, useContext, useMemo, useLayoutEffect } from "react";
import { Icon } from "@patternfly/react-core/dist/js/components/Icon";
import GripVerticalIcon from "@patternfly/react-icons/dist/js/icons/grip-vertical-icon";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export var DraggableStateContext = React.createContext({});
export var DraggableDispatchContext = React.createContext({});
export var DraggableItemContext = React.createContext({});
export function useDraggableStateContext() {
    return useContext(DraggableStateContext);
}
export function useDraggableDispatchContext() {
    return useContext(DraggableDispatchContext);
}
export function useDraggableItemContext() {
    return useContext(DraggableItemContext);
}
export function DragAndDrop(_a) {
    var _b;
    var reorder = _a.reorder, onDragEnd = _a.onDragEnd, values = _a.values, draggableItem = _a.draggableItem, isDisabled = _a.isDisabled;
    var _c = __read(useState(-1), 2), source = _c[0], setSource = _c[1];
    var _d = __read(useState(-1), 2), dest = _d[0], setDest = _d[1];
    var _e = __read(useState(false), 2), dragging = _e[0], setDragging = _e[1];
    var _f = __read(useState(-1), 2), origin = _f[0], setOrigin = _f[1];
    var _g = __read(useState(false), 2), leftOrigin = _g[0], setLeftOrigin = _g[1];
    var _h = __read(useState(values !== null && values !== void 0 ? values : []), 2), valuesCopy = _h[0], setValuesCopy = _h[1];
    var _j = __read(useState((_b = (values !== null && values !== void 0 ? values : [])) === null || _b === void 0 ? void 0 : _b.map(function (_) { return generateUuid(); })), 2), valuesKeys = _j[0], setValuesKeys = _j[1];
    useLayoutEffect(function () {
        setValuesCopy(function (prev) {
            var _a;
            if ((values === null || values === void 0 ? void 0 : values.length) !== prev.length) {
                setValuesKeys((_a = (values !== null && values !== void 0 ? values : [])) === null || _a === void 0 ? void 0 : _a.map(function (_) { return generateUuid(); }));
            }
            return values !== null && values !== void 0 ? values : [];
        });
    }, [values, isDisabled]);
    var onInternalDragStart = useCallback(function (index) {
        if (isDisabled) {
            return;
        }
        setDragging(true);
        setSource(index);
        setOrigin(index);
        setLeftOrigin(false);
    }, [isDisabled]);
    var onInternalDragOver = useCallback(function (e, index) {
        if (isDisabled) {
            return;
        }
        e.preventDefault();
        setDest(index);
    }, [isDisabled]);
    var onInternalDragEnd = useCallback(function (index) {
        if (isDisabled) {
            return;
        }
        onDragEnd === null || onDragEnd === void 0 ? void 0 : onDragEnd(origin, dest);
        setDragging(false);
        setSource(-1);
        setDest(-1);
        setOrigin(-1);
        setLeftOrigin(false);
    }, [dest, onDragEnd, origin, isDisabled]);
    var onInternalReorder = useCallback(function (source, dest) {
        if (isDisabled) {
            return;
        }
        setValuesCopy(function (prev) {
            var reordenedValues = __spreadArray([], __read(prev), false);
            var _a = __read(reordenedValues.splice(source, 1), 1), removedValue = _a[0];
            reordenedValues.splice(dest, 0, removedValue);
            return reordenedValues;
        });
        setValuesKeys(function (prev) {
            var reordenedKeys = __spreadArray([], __read(prev), false);
            var _a = __read(reordenedKeys.splice(source, 1), 1), removedKeys = _a[0];
            reordenedKeys.splice(dest, 0, removedKeys);
            return reordenedKeys;
        });
    }, [isDisabled]);
    var onInternalDragEnter = useCallback(function (index) {
        if (isDisabled) {
            return;
        }
        if (index === dest && index !== source) {
            reorder(source, dest);
            onInternalReorder(source, dest);
            setSource(dest);
            setDest(source);
        }
    }, [dest, reorder, source, onInternalReorder, isDisabled]);
    var onInternalDragLeave = useCallback(function (index) {
        if (isDisabled) {
            return;
        }
        if (!leftOrigin && index !== source) {
            setLeftOrigin(true);
        }
    }, [leftOrigin, source, isDisabled]);
    return (_jsx(DraggableStateContext.Provider, __assign({ value: {
            source: source,
            dest: dest,
            dragging: dragging,
            origin: origin,
            leftOrigin: leftOrigin,
        } }, { children: _jsx(DraggableDispatchContext.Provider, __assign({ value: {
                onDragStart: onInternalDragStart,
                onDragOver: onInternalDragOver,
                onDragEnd: onInternalDragEnd,
                onDragEnter: onInternalDragEnter,
                onDragLeave: onInternalDragLeave,
            } }, { children: valuesCopy === null || valuesCopy === void 0 ? void 0 : valuesCopy.map(function (value, index) { return _jsx("div", { children: draggableItem === null || draggableItem === void 0 ? void 0 : draggableItem(value, index) }, valuesKeys[index]); }) })) })));
}
export function Draggable(props) {
    var _a = useDraggableStateContext(), source = _a.source, dragging = _a.dragging, leftOrigin = _a.leftOrigin;
    var _b = useDraggableDispatchContext(), onDragStart = _b.onDragStart, onDragOver = _b.onDragOver, onDragEnd = _b.onDragEnd, onDragEnter = _b.onDragEnter, onDragLeave = _b.onDragLeave;
    var _c = __read(useState(-1), 2), hoveredItem = _c[0], setHoveredItem = _c[1];
    var _d = __read(useState(false), 2), draggable = _d[0], setDraggable = _d[1];
    var hovered = useMemo(function () { return hoveredItem === props.index; }, [hoveredItem, props.index]);
    var isDragging = useMemo(function () { return props.index === source && leftOrigin; }, [leftOrigin, props.index, source]);
    var rowClassName = useMemo(function () {
        var className = "kie-dmn-editor--draggable-row";
        if (hovered) {
            className += " kie-dmn-editor--draggable-row-hovered";
        }
        if (isDragging) {
            className += " kie-dmn-editor--draggable-row-is-dragging";
        }
        return className;
    }, [hovered, isDragging]);
    return (_jsxs("div", __assign({ style: props.style, className: "".concat(rowClassName, " ").concat(props.rowClassName ? props.rowClassName : ""), draggable: dragging || draggable, onDragStart: function () { return onDragStart(props.index); }, onDragOver: function (e) { return onDragOver(e, props.index); }, onDragEnd: function () {
            onDragEnd(props.index);
            setHoveredItem(-1);
        }, onDragLeave: function () { return onDragLeave(props.index); }, onDragEnter: function () { return onDragEnter(props.index); }, onPointerEnter: function () { return setHoveredItem(props.index); }, onPointerLeave: function () { return setHoveredItem(-1); }, onPointerOver: function () { return setHoveredItem(props.index); } }, { children: [!props.isDisabled ? (_jsx(Icon, __assign({ className: "kie-dmn-editor--draggable-icon", onPointerEnter: function () { return setDraggable(true); }, onPointerLeave: function () { return setDraggable(false); }, style: props.handlerStyle }, { children: _jsx(GripVerticalIcon, { className: hovered ? "kie-dmn-editor--draggable-icon-handler-hovered" : "kie-dmn-editor--draggable-icon-handler" }) }))) : (_jsx("div", { style: { width: "36px" } })), _jsx("div", __assign({ style: props.childrenStyle, className: "kie-dmn-editor--draggable-children ".concat(props.childrenClassName ? props.childrenClassName : "") }, { children: _jsx(DraggableItemContext.Provider, __assign({ value: { hovered: hovered } }, { children: props.children })) }))] })));
}
//# sourceMappingURL=Draggable.js.map